/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.AsteriskQueueListener;
import org.asteriskjava.live.AsteriskQueueMember;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueEntryImpl;
import org.asteriskjava.live.internal.AsteriskQueueMemberImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsteriskQueueImpl
extends AbstractLiveObject
implements AsteriskQueue {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String name;
    private Integer max;
    private String strategy;
    private Integer serviceLevel;
    private Integer weight;
    private final ArrayList<AsteriskQueueEntryImpl> entries;
    private final Timer timer;
    private final HashMap<String, AsteriskQueueMemberImpl> members;
    private final List<AsteriskQueueListener> listeners;
    private final HashMap<AsteriskQueueEntry, ServiceLevelTimerTask> serviceLevelTimerTasks;

    AsteriskQueueImpl(AsteriskServerImpl server, String name, Integer max, String strategy, Integer serviceLevel, Integer weight) {
        super(server);
        this.name = name;
        this.max = max;
        this.strategy = strategy;
        this.serviceLevel = serviceLevel;
        this.weight = weight;
        this.entries = new ArrayList(25);
        this.listeners = new ArrayList<AsteriskQueueListener>();
        this.members = new HashMap();
        this.timer = new Timer("ServiceLevelTimer-" + name, true);
        this.serviceLevelTimerTasks = new HashMap();
    }

    void cancelServiceLevelTimer() {
        this.timer.cancel();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public Integer getServiceLevel() {
        return this.serviceLevel;
    }

    void setServiceLevel(Integer serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    void setWeight(Integer weight) {
        this.weight = weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsteriskQueueEntry> getEntries() {
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            return new ArrayList<AsteriskQueueEntry>(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shift() {
        int currentPos = 1;
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            for (AsteriskQueueEntryImpl qe : this.entries) {
                if (qe.getPosition() != currentPos) {
                    qe.setPosition(currentPos);
                }
                ++currentPos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createNewEntry(AsteriskChannelImpl channel, int reportedPosition, Date dateReceived) {
        AsteriskQueueEntryImpl qe = new AsteriskQueueEntryImpl(this.server, this, channel, reportedPosition, dateReceived);
        long delay = (long)this.serviceLevel.intValue() * 1000L;
        if (delay > 0L) {
            ServiceLevelTimerTask timerTask = new ServiceLevelTimerTask(qe);
            this.timer.schedule((TimerTask)timerTask, delay);
            HashMap<AsteriskQueueEntry, ServiceLevelTimerTask> hashMap = this.serviceLevelTimerTasks;
            synchronized (hashMap) {
                this.serviceLevelTimerTasks.put(qe, timerTask);
            }
        }
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            this.entries.add(qe);
            this.shift();
        }
        channel.setQueueEntry(qe);
        this.fireNewEntry(qe);
        this.server.fireNewQueueEntry(qe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(AsteriskQueueEntryImpl entry, Date dateReceived) {
        boolean changed;
        HashMap<AsteriskQueueEntry, ServiceLevelTimerTask> hashMap = this.serviceLevelTimerTasks;
        synchronized (hashMap) {
            if (this.serviceLevelTimerTasks.containsKey(entry)) {
                ServiceLevelTimerTask timerTask = this.serviceLevelTimerTasks.get(entry);
                timerTask.cancel();
                this.serviceLevelTimerTasks.remove(entry);
            }
        }
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            changed = this.entries.remove(entry);
            if (changed) {
                this.shift();
            }
        }
        if (changed) {
            entry.getChannel().setQueueEntry(null);
            entry.left(dateReceived);
            this.fireEntryLeave(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer("AsteriskQueue[");
        sb.append("name='").append(this.getName()).append("',");
        sb.append("max='").append(this.getMax()).append("',");
        sb.append("strategy='").append(this.getStrategy()).append("',");
        sb.append("serviceLevel='").append(this.getServiceLevel()).append("',");
        sb.append("weight='").append(this.getWeight()).append("',");
        Cloneable cloneable = this.entries;
        synchronized (cloneable) {
            sb.append("entries='").append(this.entries.toString()).append("',");
        }
        cloneable = this.members;
        synchronized (cloneable) {
            sb.append("members='").append(this.members.toString()).append("',");
        }
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsteriskQueueListener(AsteriskQueueListener listener) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAsteriskQueueListener(AsteriskQueueListener listener) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewEntry(AsteriskQueueEntryImpl entry) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onNewEntry(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onNewEntry()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEntryLeave(AsteriskQueueEntryImpl entry) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onEntryLeave(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onEntryLeave()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberAdded(AsteriskQueueMemberImpl member) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onMemberAdded(member);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onMemberAdded()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberRemoved(AsteriskQueueMemberImpl member) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onMemberRemoved(member);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onMemberRemoved()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AsteriskQueueMember> getMembers() {
        ArrayList<AsteriskQueueMember> listOfMembers = new ArrayList<AsteriskQueueMember>(this.members.size());
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            for (AsteriskQueueMemberImpl asteriskQueueMember : this.members.values()) {
                listOfMembers.add(asteriskQueueMember);
            }
        }
        return listOfMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueMemberImpl getMember(String location) {
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            if (this.members.containsKey(location)) {
                return this.members.get(location);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMember(AsteriskQueueMemberImpl member) {
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            if (this.members.containsValue(member)) {
                return;
            }
            this.logger.info("Adding new member to the queue " + this.getName() + ": " + member.toString());
            this.members.put(member.getLocation(), member);
        }
        this.fireMemberAdded(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueMemberImpl getMemberByLocation(String location) {
        AsteriskQueueMemberImpl member;
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            member = this.members.get(location);
        }
        if (member == null) {
            this.logger.error("Requested member at location " + location + " not found!");
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberStateChanged(AsteriskQueueMemberImpl member) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onMemberStateChange(member);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onMemberStateChange()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueEntryImpl getEntry(String channelName) {
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            for (AsteriskQueueEntryImpl entry : this.entries) {
                if (!entry.getChannel().getName().equals(channelName)) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(AsteriskQueueMemberImpl member) {
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            if (!this.members.containsValue(member)) {
                return;
            }
            this.logger.info("Remove member from the queue " + this.getName() + ": " + member.toString());
            this.members.remove(member.getLocation());
        }
        this.fireMemberRemoved(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireServiceLevelExceeded(AsteriskQueueEntry entry) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onEntryServiceLevelExceeded(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in fireServiceLevelExceeded()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueEntryImpl getEntry(int position) {
        --position;
        AsteriskQueueEntryImpl foundEntry = null;
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            try {
                foundEntry = this.entries.get(position);
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        return foundEntry;
    }

    private class ServiceLevelTimerTask
    extends TimerTask {
        private final AsteriskQueueEntry entry;

        ServiceLevelTimerTask(AsteriskQueueEntry entry) {
            this.entry = entry;
        }

        public void run() {
            AsteriskQueueImpl.this.fireServiceLevelExceeded(this.entry);
        }
    }
}

