/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.QueueMemberState;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueEntryImpl;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskQueueMemberImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.ChannelManager;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.QueueStatusAction;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.QueueEntryEvent;
import org.asteriskjava.manager.event.QueueMemberAddedEvent;
import org.asteriskjava.manager.event.QueueMemberEvent;
import org.asteriskjava.manager.event.QueueMemberPausedEvent;
import org.asteriskjava.manager.event.QueueMemberPenaltyEvent;
import org.asteriskjava.manager.event.QueueMemberRemovedEvent;
import org.asteriskjava.manager.event.QueueMemberStatusEvent;
import org.asteriskjava.manager.event.QueueParamsEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueueManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AsteriskServerImpl server;
    private final ChannelManager channelManager;
    private final Map<String, AsteriskQueueImpl> queues;

    QueueManager(AsteriskServerImpl server, ChannelManager channelManager) {
        this.server = server;
        this.channelManager = channelManager;
        this.queues = new HashMap<String, AsteriskQueueImpl>();
    }

    void initialize() throws ManagerCommunicationException {
        ResponseEvents re;
        try {
            re = this.server.sendEventGeneratingAction(new QueueStatusAction());
        }
        catch (ManagerCommunicationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EventTimeoutException) {
                re = ((EventTimeoutException)cause).getPartialResult();
            }
            throw e;
        }
        for (ResponseEvent event : re.getEvents()) {
            if (event instanceof QueueParamsEvent) {
                this.handleQueueParamsEvent((QueueParamsEvent)event);
                continue;
            }
            if (event instanceof QueueMemberEvent) {
                this.handleQueueMemberEvent((QueueMemberEvent)event);
                continue;
            }
            if (!(event instanceof QueueEntryEvent)) continue;
            this.handleQueueEntryEvent((QueueEntryEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnected() {
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            for (AsteriskQueueImpl queue : this.queues.values()) {
                queue.cancelServiceLevelTimer();
            }
            this.queues.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AsteriskQueue> getQueues() {
        ArrayList<AsteriskQueue> copy;
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            copy = new ArrayList<AsteriskQueue>(this.queues.values());
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQueue(AsteriskQueueImpl queue) {
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            this.queues.put(queue.getName(), queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueueParamsEvent(QueueParamsEvent event) {
        String name = event.getQueue();
        Integer max = event.getMax();
        String strategy = event.getStrategy();
        Integer serviceLevel = event.getServiceLevel();
        Integer weight = event.getWeight();
        AsteriskQueueImpl queue = this.queues.get(name);
        if (queue == null) {
            queue = new AsteriskQueueImpl(this.server, name, max, strategy, serviceLevel, weight);
            this.logger.info("Adding new queue " + queue);
            this.addQueue(queue);
        } else {
            AsteriskQueueImpl asteriskQueueImpl = queue;
            synchronized (asteriskQueueImpl) {
                queue.setMax(max);
                queue.setServiceLevel(serviceLevel);
                queue.setWeight(weight);
            }
        }
    }

    private void handleQueueMemberEvent(QueueMemberEvent event) {
        AsteriskQueueImpl queue = this.queues.get(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMember(event.getLocation());
        if (member == null) {
            member = new AsteriskQueueMemberImpl(this.server, queue, event.getLocation(), QueueMemberState.valueOf(event.getStatus()), event.getPaused(), event.getPenalty(), event.getMembership());
        }
        queue.addMember(member);
    }

    private void handleQueueEntryEvent(QueueEntryEvent event) {
        AsteriskQueueImpl queue = this.getQueueByName(event.getQueue());
        AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(event.getChannel());
        if (queue == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown channel " + event.getChannel());
            return;
        }
        if (queue.getEntry(event.getChannel()) != null) {
            this.logger.error("Ignored duplicate queue entry during population in queue " + event.getQueue() + " for channel " + event.getChannel());
            return;
        }
        int reportedPosition = event.getPosition();
        queue.createNewEntry(channel, reportedPosition, event.getDateReceived());
    }

    void handleJoinEvent(JoinEvent event) {
        AsteriskQueueImpl queue = this.getQueueByName(event.getQueue());
        AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(event.getChannel());
        if (queue == null) {
            this.logger.error("Ignored JoinEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("Ignored JoinEvent for unknown channel " + event.getChannel());
            return;
        }
        if (queue.getEntry(event.getChannel()) != null) {
            this.logger.error("Ignored duplicate queue entry in queue " + event.getQueue() + " for channel " + event.getChannel());
            return;
        }
        int reportedPosition = event.getPosition();
        queue.createNewEntry(channel, reportedPosition, event.getDateReceived());
    }

    void handleLeaveEvent(LeaveEvent event) {
        AsteriskQueueImpl queue = this.getQueueByName(event.getQueue());
        AsteriskChannelImpl channel = this.channelManager.getChannelImplByName(event.getChannel());
        if (queue == null) {
            this.logger.error("Ignored LeaveEvent for unknown queue " + event.getQueue());
            return;
        }
        if (channel == null) {
            this.logger.error("Ignored LeaveEvent for unknown channel " + event.getChannel());
            return;
        }
        AsteriskQueueEntryImpl existingQueueEntry = queue.getEntry(event.getChannel());
        if (existingQueueEntry == null) {
            this.logger.error("Ignored leave event for non existing queue entry in queue " + event.getQueue() + " for channel " + event.getChannel());
            return;
        }
        queue.removeEntry(existingQueueEntry, event.getDateReceived());
    }

    void handleQueueMemberStatusEvent(QueueMemberStatusEvent event) {
        AsteriskQueueImpl queue = this.getQueueByName(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMemberByLocation(event.getLocation());
        if (member == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown member " + event.getLocation());
            return;
        }
        member.stateChanged(QueueMemberState.valueOf(event.getStatus()));
        member.penaltyChanged(event.getPenalty());
        queue.fireMemberStateChanged(member);
    }

    void handleQueueMemberPausedEvent(QueueMemberPausedEvent event) {
        AsteriskQueueImpl queue = this.getQueueByName(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberPausedEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMemberByLocation(event.getLocation());
        if (member == null) {
            this.logger.error("Ignored QueueMemberPausedEvent for unknown member " + event.getLocation());
            return;
        }
        member.pausedChanged(event.getPaused());
    }

    void handleQueueMemberPenaltyEvent(QueueMemberPenaltyEvent event) {
        AsteriskQueueImpl queue = this.getQueueByName(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMemberByLocation(event.getLocation());
        if (member == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown member " + event.getLocation());
            return;
        }
        member.penaltyChanged(event.getPenalty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsteriskQueueImpl getQueueByName(String queueName) {
        AsteriskQueueImpl queue;
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            queue = this.queues.get(queueName);
        }
        if (queue == null) {
            this.logger.error("Requested queue '" + queueName + "' not found!");
        }
        return queue;
    }

    public void handleQueueMemberAddedEvent(QueueMemberAddedEvent event) {
        AsteriskQueueImpl queue = this.queues.get(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberAddedEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMember(event.getLocation());
        if (member == null) {
            member = new AsteriskQueueMemberImpl(this.server, queue, event.getLocation(), QueueMemberState.valueOf(event.getStatus()), event.getPaused(), event.getPenalty(), event.getMembership());
        }
        queue.addMember(member);
    }

    public void handleQueueMemberRemovedEvent(QueueMemberRemovedEvent event) {
        AsteriskQueueImpl queue = this.queues.get(event.getQueue());
        if (queue == null) {
            this.logger.error("Ignored QueueMemberRemovedEvent for unknown queue " + event.getQueue());
            return;
        }
        AsteriskQueueMemberImpl member = queue.getMember(event.getLocation());
        if (member == null) {
            this.logger.error("Ignored QueueMemberRemovedEvent for unknown agent name: " + event.getMemberName() + " location: " + event.getLocation() + " queue: " + event.getQueue());
            return;
        }
        queue.removeMember(member);
    }
}

