/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.internal.Trace;

public class FileTrace
implements Trace {
    public static final String TRACE_DIRECTORY_PROPERTY = "org.asteriskjava.trace.directory";
    protected static final String FILE_PREFIX = "aj-trace";
    protected static final String FILE_SUFFIX = ".txt";
    private final Log logger = LogFactory.getLog(FileTrace.class);
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSzzz");
    private Charset charset = Charset.forName("UTF-8");
    private FileChannel channel;
    private boolean exceptionLogged = false;

    public FileTrace(Socket socket) throws IOException {
        this.channel = new RandomAccessFile(this.getFile(socket), "rw").getChannel();
        this.print(this.getHeader(socket));
    }

    private String getHeader(Socket socket) {
        StringBuilder sb = new StringBuilder();
        sb.append("Local:  ");
        sb.append(socket.getLocalAddress());
        sb.append(":");
        sb.append(socket.getLocalPort());
        sb.append("\n");
        sb.append("Remote: ");
        sb.append(socket.getInetAddress());
        sb.append(":");
        sb.append(socket.getPort());
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    private File getFile(Socket socket) {
        String directory = System.getProperty(TRACE_DIRECTORY_PROPERTY, System.getProperty("java.io.tmpdir"));
        String fileName = this.getFileName(socket);
        this.logger.info("Writing trace to " + directory + File.separator + fileName);
        return new File(directory, fileName);
    }

    private String getFileName(Socket socket) {
        StringBuilder sb = new StringBuilder(FILE_PREFIX);
        sb.append("_");
        sb.append(this.df.format(new Date()));
        sb.append("_");
        sb.append(socket.getLocalAddress().getHostAddress());
        sb.append(":");
        sb.append(socket.getLocalPort());
        sb.append("_");
        sb.append(socket.getInetAddress().getHostAddress());
        sb.append(":");
        sb.append(socket.getPort());
        sb.append(FILE_SUFFIX);
        return sb.toString();
    }

    public synchronized void received(String s) {
        try {
            this.print(this.format("<<< ", s));
        }
        catch (IOException e) {
            this.logException(e);
        }
    }

    public synchronized void sent(String s) {
        try {
            this.print(this.format(">>> ", s));
        }
        catch (IOException e) {
            this.logException(e);
        }
    }

    private void logException(IOException e) {
        if (this.exceptionLogged) {
            return;
        }
        this.logger.warn("Unable to write trace to disk", e);
        this.exceptionLogged = true;
    }

    protected String format(String prefix, String s) {
        StringBuilder sb = new StringBuilder(this.df.format(new Date()));
        String filler = String.format("%" + sb.length() + "s", "");
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i != 0) {
                sb.append(filler);
            }
            sb.append(" ");
            sb.append(prefix);
            sb.append(lines[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    protected void print(String s) throws IOException {
        CharBuffer charBuffer = CharBuffer.allocate(s.length());
        charBuffer.put(s);
        charBuffer.flip();
        this.print(this.charset.encode(charBuffer));
    }

    private void print(ByteBuffer byteBuffer) throws IOException {
        int bytesWritten = 0;
        while (bytesWritten < byteBuffer.remaining()) {
            bytesWritten = this.channel.write(byteBuffer);
            if (bytesWritten != 0) continue;
            throw new IOException("Unable to write trace to channel. Media may be full.");
        }
    }
}

