/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;

public class AppendExpr
extends Expr {
    private final Expr _value;
    private AppendExpr _next;

    protected AppendExpr(Expr value, AppendExpr next) {
        this._value = value;
        this._next = next;
    }

    public Expr getValue() {
        return this._value;
    }

    public AppendExpr getNext() {
        return this._next;
    }

    void setNext(AppendExpr next) {
        this._next = next;
    }

    public boolean isString() {
        return true;
    }

    public Value eval(Env env) {
        Value value = this._value.eval(env);
        StringValue sb = value.toStringBuilder(env);
        AppendExpr ptr = this._next;
        while (ptr != null) {
            Value ptrValue = ptr._value.eval(env);
            sb = sb.appendUnicode(ptrValue);
            ptr = ptr._next;
        }
        return sb;
    }

    public String evalString(Env env) {
        Value value = this._value.eval(env);
        StringValue sb = value.toStringBuilder();
        AppendExpr ptr = this._next;
        while (ptr != null) {
            sb = sb.appendUnicode(ptr._value.eval(env));
            ptr = ptr._next;
        }
        return sb.toString();
    }

    public String toString() {
        if (this._next != null) {
            return "(" + this._value + " . " + this._next + ")";
        }
        return String.valueOf(this._value);
    }
}

