/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallExpr
extends Expr {
    private static final L10N L = new L10N(MethodCallExpr.class);
    protected final Expr _objExpr;
    protected final String _methodName;
    protected final int _hash;
    protected final char[] _name;
    protected final Expr[] _args;

    public MethodCallExpr(Location location, Expr objExpr, String name, ArrayList<Expr> args) {
        super(location);
        this._objExpr = objExpr;
        this._methodName = name;
        this._name = name.toCharArray();
        this._hash = MethodMap.hash(this._name, this._name.length);
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public MethodCallExpr(Expr objExpr, String name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, objExpr, name, args);
    }

    public String getName() {
        return this._methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        env.checkTimeout();
        Value obj = this._objExpr.eval(env);
        Value[] args = new Value[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            args[i] = this._args[i].evalArg(env);
        }
        env.pushCall(this, obj, args);
        try {
            env.checkTimeout();
            Value value = obj.callMethod(env, this._hash, this._name, this._name.length, args);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value evalRef(Env env) {
        env.checkTimeout();
        Value obj = this._objExpr.eval(env);
        Value[] args = new Value[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            args[i] = this._args[i].evalArg(env);
        }
        env.pushCall(this, obj, args);
        try {
            env.checkTimeout();
            Value value = obj.callMethodRef(env, this._hash, this._name, this._name.length, args);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public String toString() {
        return this._objExpr + "->" + this._methodName + "()";
    }
}

