/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaURLValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;
import java.net.URL;

public class URLMarshal
extends Marshal {
    public static final Marshal MARSHAL = new URLMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaURL(env);
    }

    public Value unmarshal(Env env, Object value) {
        return env.wrapJava((URL)value);
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaURLValue) {
            return 0;
        }
        if (argValue.isString()) {
            return 300;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return URL.class;
    }
}

