/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApacheModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ApacheModule.class);
    private static final Logger log = Logger.getLogger(ApacheModule.class.getName());

    public boolean apache_child_terminate() {
        return false;
    }

    public String apache_note(Env env, String name, @Optional Value value) {
        HttpServletRequest req = env.getRequest();
        Object oldValue = req.getAttribute(name);
        if (value.isset()) {
            req.setAttribute(name, (Object)value.toString());
        }
        if (oldValue != null) {
            return oldValue.toString();
        }
        return null;
    }

    public Value apache_request_headers(Env env) {
        HttpServletRequest req = env.getRequest();
        ArrayValueImpl result = new ArrayValueImpl();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result.put(env.createString(key), env.createString(req.getHeader(key)));
        }
        return result;
    }

    public boolean apache_reset_timeout() {
        return false;
    }

    public Value getallheaders(Env env) {
        return this.apache_request_headers(env);
    }

    public boolean virtual(Env env, String url) {
        try {
            HttpServletRequest req = env.getRequest();
            HttpServletResponse res = env.getResponse();
            env.getOut().flushBuffer();
            req.getRequestDispatcher(url).include((ServletRequest)req, (ServletResponse)res);
            return true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }
}

