/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.OutputBuffer;
import com.caucho.quercus.env.StringBuilderOutputStream;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.HttpModule;
import com.caucho.quercus.lib.UrlRewriterCallback;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.quercus.module.ModuleStartupListener;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class OutputModule
extends AbstractQuercusModule
implements ModuleStartupListener {
    private static final L10N L = new L10N(OutputModule.class);
    private static final Logger log = Logger.getLogger(OutputModule.class.getName());
    private static final StringValue HTTP_ACCEPT_ENCODING = new StringBuilderValue("HTTP_ACCEPT_ENCODING");
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    private static HashMap<Env, GZOutputPair> _gzOutputPairs = new HashMap();
    static final IniDefinition INI_OUTPUT_BUFFERING = _iniDefinitions.add("output_buffering", false, 2);
    static final IniDefinition INI_OUTPUT_HANDLER = _iniDefinitions.add("output_handler", "", 2);
    static final IniDefinition INI_IMPLICIT_FLUSH = _iniDefinitions.add("implicit_flush", false, 7);

    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    public void startup(Env env) {
        boolean isOutputBuffering = INI_OUTPUT_BUFFERING.getAsBoolean(env);
        String handlerName = INI_OUTPUT_HANDLER.getAsString(env);
        if (handlerName != null && !"".equals(handlerName) && env.getFunction(handlerName) != null) {
            Callback callback = env.createCallback(env.createString(handlerName));
            OutputModule.ob_start(env, callback, 0, true);
        } else if (isOutputBuffering) {
            OutputModule.ob_start(env, null, 0, true);
        }
        OutputModule.ob_implicit_flush(env, isOutputBuffering);
    }

    public Value flush(Env env) {
        try {
            env.getOriginalOut().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return NullValue.NULL;
    }

    public static Value ob_clean(Env env) {
        OutputBuffer ob = env.getOutputBuffer();
        if (ob != null) {
            ob.clean();
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    public static boolean ob_end_clean(Env env) {
        OutputBuffer ob = env.getOutputBuffer();
        if (ob != null) {
            ob.clean();
            Callback callback = ob.getCallback();
            if (callback != null) {
                ob.setCallback(null);
            }
        }
        return env.popOutputBuffer();
    }

    public static boolean ob_end_flush(Env env) {
        return env.popOutputBuffer();
    }

    public static Value ob_get_clean(Env env) {
        OutputBuffer ob = env.getOutputBuffer();
        if (ob != null) {
            Value result = ob.getContents();
            ob.clean();
            return result;
        }
        return BooleanValue.FALSE;
    }

    public static Value ob_get_contents(Env env) {
        OutputBuffer ob = env.getOutputBuffer();
        if (ob != null) {
            return ob.getContents();
        }
        return BooleanValue.FALSE;
    }

    public static Value ob_get_flush(Env env) {
        OutputBuffer ob = env.getOutputBuffer();
        Value result = BooleanValue.FALSE;
        if (ob != null) {
            result = ob.getContents();
        }
        env.popOutputBuffer();
        return result;
    }

    public static Value ob_flush(Env env) {
        OutputBuffer ob = env.getOutputBuffer();
        if (ob != null) {
            ob.flush();
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    public static Value ob_get_length(Env env) {
        OutputBuffer ob = env.getOutputBuffer();
        if (ob != null) {
            return LongValue.create(ob.getLength());
        }
        return BooleanValue.FALSE;
    }

    public static Value ob_get_level(Env env) {
        OutputBuffer ob = env.getOutputBuffer();
        if (ob != null) {
            return LongValue.create(ob.getLevel());
        }
        return LongValue.ZERO;
    }

    private static void listHandlers(Env env, OutputBuffer ob, ArrayValue handlers) {
        if (ob == null) {
            return;
        }
        OutputModule.listHandlers(env, ob.getNext(), handlers);
        Callback callback = ob.getCallback();
        if (callback != null) {
            handlers.put(env.createString(callback.getCallbackName()));
        } else {
            handlers.put(env.createString("default output handler"));
        }
    }

    public static Value ob_list_handlers(Env env) {
        OutputBuffer ob = env.getOutputBuffer();
        ArrayValueImpl handlers = new ArrayValueImpl();
        OutputModule.listHandlers(env, ob, handlers);
        return handlers;
    }

    private static void putCommonStatus(ArrayValue element, OutputBuffer ob, Env env, boolean fullStatus) {
        LongValue type = LongValue.ONE;
        Callback callback = ob.getCallback();
        if (callback != null && callback.isInternal()) {
            type = LongValue.ZERO;
        }
        element.put(env.createString("type"), type);
        if (fullStatus && callback != null && callback == UrlRewriterCallback.getInstance(env)) {
            element.put(env.createString("buffer_size"), LongValue.ZERO);
        }
        LongValue status = ob.haveFlushed() ? LongValue.ONE : LongValue.ZERO;
        element.put(env.createString("status"), status);
        StringValue name = callback != null ? env.createString(callback.getCallbackName()) : env.createString("default output handler".intern());
        element.put(env.createString("name".intern()), name);
        BooleanValue del = ob.getEraseFlag() ? BooleanValue.TRUE : BooleanValue.FALSE;
        element.put(env.createString("del"), del);
    }

    private static void getFullStatus(OutputBuffer ob, Env env, ArrayValue result) {
        if (ob == null) {
            return;
        }
        OutputModule.getFullStatus(ob.getNext(), env, result);
        ArrayValueImpl element = new ArrayValueImpl();
        element.put(env.createString("chunk_size"), LongValue.create(ob.getChunkSize()));
        element.put(env.createString("size"), LongValue.create(-1L));
        element.put(env.createString("block_size"), LongValue.create(-1L));
        OutputModule.putCommonStatus(element, ob, env, true);
        result.put(element);
    }

    public static Value ob_get_status(Env env, @Optional boolean full_status) {
        if (full_status) {
            OutputBuffer ob = env.getOutputBuffer();
            ArrayValueImpl result = new ArrayValueImpl();
            OutputModule.getFullStatus(ob, env, result);
            return result;
        }
        OutputBuffer ob = env.getOutputBuffer();
        ArrayValueImpl result = new ArrayValueImpl();
        if (ob != null) {
            result.put(env.createString("level"), LongValue.create(ob.getLevel()));
            OutputModule.putCommonStatus(result, ob, env, false);
        }
        return result;
    }

    public static Value ob_implicit_flush(Env env, @Optional(value="true") boolean flag) {
        if (env.getOriginalOut() != null) {
            env.getOriginalOut().setImplicitFlush(flag);
        }
        return NullValue.NULL;
    }

    public static boolean ob_start(Env env, @Optional Callback callback, @Optional int chunkSize, @Optional(value="true") boolean erase) {
        if (callback != null && callback.getCallbackName().equals("ob_gzhandler")) {
            for (OutputBuffer ob = env.getOutputBuffer(); ob != null; ob = ob.getNext()) {
                Callback cb = ob.getCallback();
                if (!cb.getCallbackName().equals("ob_gzhandler")) continue;
                env.warning(L.l("output handler 'ob_gzhandler' cannot be used twice"));
                return false;
            }
        }
        env.pushOutputBuffer(callback, chunkSize, erase);
        return true;
    }

    public static UrlRewriterCallback pushUrlRewriter(Env env) {
        UrlRewriterCallback rewriter = UrlRewriterCallback.getInstance(env);
        if (rewriter == null) {
            OutputBuffer ob = env.getOutputBuffer();
            rewriter = new UrlRewriterCallback(env);
            if (ob != null && ob.getCallback() == null) {
                ob.setCallback(rewriter);
            } else {
                OutputModule.ob_start(env, rewriter, 0, true);
            }
        }
        return rewriter;
    }

    public static boolean output_add_rewrite_var(Env env, String name, String value) {
        UrlRewriterCallback rewriter = OutputModule.pushUrlRewriter(env);
        rewriter.addRewriterVar(name, value);
        return true;
    }

    public static boolean output_reset_rewrite_vars(Env env) {
        UrlRewriterCallback rewriter = UrlRewriterCallback.getInstance(env);
        rewriter.resetRewriterVars();
        return true;
    }

    public static Value ob_gzhandler(Env env, StringValue buffer, int state) {
        String[] acceptedList;
        Encoding encoding = Encoding.NONE;
        Var _SERVER = env.getGlobalVar("_SERVER");
        for (String accepted : acceptedList = ((Value)_SERVER).get(HTTP_ACCEPT_ENCODING).toString().split(",")) {
            if ((accepted = accepted.trim()).equalsIgnoreCase("gzip")) {
                encoding = Encoding.GZIP;
                break;
            }
            if (!accepted.equalsIgnoreCase("deflate")) continue;
            encoding = Encoding.DEFLATE;
            break;
        }
        if (encoding == Encoding.NONE) {
            return BooleanValue.FALSE;
        }
        GZOutputPair pair = null;
        StringValue result = env.createBinaryBuilder();
        if ((state & 1) != 0) {
            HttpModule.header(env, env.createString("Vary: Accept-Encoding"), true, 0L);
            boolean encodingFlag = false;
            pair = new GZOutputPair();
            pair._tempStream = new StringBuilderOutputStream(result);
            pair._tempStream.setStringBuilder(result);
            try {
                if (encoding == Encoding.GZIP) {
                    HttpModule.header(env, env.createString("Content-Encoding: gzip"), true, 0L);
                    pair._outputStream = new GZIPOutputStream(pair._tempStream);
                } else if (encoding == Encoding.DEFLATE) {
                    HttpModule.header(env, env.createString("Content-Encoding: deflate"), true, 0L);
                    pair._outputStream = new DeflaterOutputStream(pair._tempStream);
                }
            }
            catch (IOException e) {
                return BooleanValue.FALSE;
            }
            env.setGzStream(pair);
        } else {
            pair = (GZOutputPair)env.getGzStream();
            if (pair == null) {
                return BooleanValue.FALSE;
            }
            pair._tempStream.setStringBuilder(result);
        }
        try {
            buffer.writeTo(pair._outputStream);
            pair._outputStream.flush();
            if ((state & 4) != 0) {
                pair._outputStream.close();
            }
        }
        catch (IOException e) {
            return BooleanValue.FALSE;
        }
        pair._tempStream.setStringBuilder(null);
        return result;
    }

    private static class GZOutputPair {
        public StringBuilderOutputStream _tempStream;
        public OutputStream _outputStream;

        private GZOutputPair() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Encoding {
        NONE,
        GZIP,
        DEFLATE;

    }
}

