/*
 * Decompiled with CFR 0.152.
 */
package jruby.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jruby.objectweb.asm.AnnotationVisitor;
import jruby.objectweb.asm.Attribute;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Type;
import jruby.objectweb.asm.tree.AnnotationNode;
import jruby.objectweb.asm.tree.FieldInsnNode;
import jruby.objectweb.asm.tree.FrameNode;
import jruby.objectweb.asm.tree.IincInsnNode;
import jruby.objectweb.asm.tree.InsnList;
import jruby.objectweb.asm.tree.InsnNode;
import jruby.objectweb.asm.tree.IntInsnNode;
import jruby.objectweb.asm.tree.JumpInsnNode;
import jruby.objectweb.asm.tree.LabelNode;
import jruby.objectweb.asm.tree.LdcInsnNode;
import jruby.objectweb.asm.tree.LineNumberNode;
import jruby.objectweb.asm.tree.LocalVariableNode;
import jruby.objectweb.asm.tree.LookupSwitchInsnNode;
import jruby.objectweb.asm.tree.MemberNode;
import jruby.objectweb.asm.tree.MethodInsnNode;
import jruby.objectweb.asm.tree.MethodNode$1;
import jruby.objectweb.asm.tree.MultiANewArrayInsnNode;
import jruby.objectweb.asm.tree.TableSwitchInsnNode;
import jruby.objectweb.asm.tree.TryCatchBlockNode;
import jruby.objectweb.asm.tree.TypeInsnNode;
import jruby.objectweb.asm.tree.VarInsnNode;

public class MethodNode
extends MemberNode
implements MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List exceptions;
    public Object annotationDefault;
    public List[] visibleParameterAnnotations;
    public List[] invisibleParameterAnnotations;
    public InsnList instructions = new InsnList();
    public List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List localVariables;

    public MethodNode() {
    }

    public MethodNode(int n, String string2, String string3, String string4, String[] stringArray) {
        this();
        boolean bl;
        this.access = n;
        this.name = string2;
        this.desc = string3;
        this.signature = string4;
        this.exceptions = new ArrayList(stringArray == null ? 0 : stringArray.length);
        boolean bl2 = bl = (n & 0x400) != 0;
        if (!bl) {
            this.localVariables = new ArrayList(5);
        }
        this.tryCatchBlocks = new ArrayList();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode(new MethodNode$1(this, 0));
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string2, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string2);
        if (bl) {
            if (this.visibleParameterAnnotations == null) {
                int n2 = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[n2];
            }
            if (this.visibleParameterAnnotations[n] == null) {
                this.visibleParameterAnnotations[n] = new ArrayList(1);
            }
            this.visibleParameterAnnotations[n].add(annotationNode);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int n3 = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[n3];
            }
            if (this.invisibleParameterAnnotations[n] == null) {
                this.invisibleParameterAnnotations[n] = new ArrayList(1);
            }
            this.invisibleParameterAnnotations[n].add(annotationNode);
        }
        return annotationNode;
    }

    public void visitCode() {
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.instructions.add(new FrameNode(n, n2, objectArray == null ? null : MethodNode.labelNodes(objectArray), n3, objectArray2 == null ? null : MethodNode.labelNodes(objectArray2)));
    }

    public void visitInsn(int n) {
        this.instructions.add(new InsnNode(n));
    }

    public void visitIntInsn(int n, int n2) {
        this.instructions.add(new IntInsnNode(n, n2));
    }

    public void visitVarInsn(int n, int n2) {
        this.instructions.add(new VarInsnNode(n, n2));
    }

    public void visitTypeInsn(int n, String string2) {
        this.instructions.add(new TypeInsnNode(n, string2));
    }

    public void visitFieldInsn(int n, String string2, String string3, String string4) {
        this.instructions.add(new FieldInsnNode(n, string2, string3, string4));
    }

    public void visitMethodInsn(int n, String string2, String string3, String string4) {
        this.instructions.add(new MethodInsnNode(n, string2, string3, string4));
    }

    public void visitJumpInsn(int n, Label label) {
        this.instructions.add(new JumpInsnNode(n, MethodNode.labelNode(label)));
    }

    public void visitLabel(Label label) {
        this.instructions.add(MethodNode.labelNode(label));
    }

    public void visitLdcInsn(Object object) {
        this.instructions.add(new LdcInsnNode(object));
    }

    public void visitIincInsn(int n, int n2) {
        this.instructions.add(new IincInsnNode(n, n2));
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        this.instructions.add(new TableSwitchInsnNode(n, n2, MethodNode.labelNode(label), MethodNode.labelNodes(labelArray)));
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.instructions.add(new LookupSwitchInsnNode(MethodNode.labelNode(label), nArray, MethodNode.labelNodes(labelArray)));
    }

    public void visitMultiANewArrayInsn(String string2, int n) {
        this.instructions.add(new MultiANewArrayInsnNode(string2, n));
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string2) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(MethodNode.labelNode(label), MethodNode.labelNode(label2), MethodNode.labelNode(label3), string2));
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label, Label label2, int n) {
        this.localVariables.add(new LocalVariableNode(string2, string3, string4, MethodNode.labelNode(label), MethodNode.labelNode(label2), n));
    }

    public void visitLineNumber(int n, Label label) {
        this.instructions.add(new LineNumberNode(n, MethodNode.labelNode(label)));
    }

    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    private static LabelNode labelNode(Label label) {
        if (label.info == null) {
            label.info = new LabelNode(label);
        }
        return (LabelNode)label.info;
    }

    private static LabelNode[] labelNodes(Label[] labelArray) {
        LabelNode[] labelNodeArray = new LabelNode[labelArray.length];
        for (int i = 0; i < labelArray.length; ++i) {
            labelNodeArray[i] = MethodNode.labelNode(labelArray[i]);
        }
        return labelNodeArray;
    }

    private static Object[] labelNodes(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof Label) {
                object = MethodNode.labelNode((Label)object);
            }
            objectArray2[i] = object;
        }
        return objectArray2;
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, stringArray);
        if (methodVisitor != null) {
            this.accept(methodVisitor);
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        AnnotationNode annotationNode;
        int n;
        int n2;
        Object object;
        if (this.annotationDefault != null) {
            object = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept((AnnotationVisitor)object, null, this.annotationDefault);
            if (object != null) {
                object.visitEnd();
            }
        }
        int n3 = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (AnnotationNode)this.visibleAnnotations.get(n2);
            ((AnnotationNode)object).accept(methodVisitor.visitAnnotation(((AnnotationNode)object).desc, true));
        }
        n3 = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (AnnotationNode)this.invisibleAnnotations.get(n2);
            ((AnnotationNode)object).accept(methodVisitor.visitAnnotation(((AnnotationNode)object).desc, false));
        }
        n3 = this.visibleParameterAnnotations == null ? 0 : this.visibleParameterAnnotations.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.visibleParameterAnnotations[n2];
            if (object == null) continue;
            for (n = 0; n < object.size(); ++n) {
                annotationNode = (AnnotationNode)object.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, true));
            }
        }
        n3 = this.invisibleParameterAnnotations == null ? 0 : this.invisibleParameterAnnotations.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.invisibleParameterAnnotations[n2];
            if (object == null) continue;
            for (n = 0; n < object.size(); ++n) {
                annotationNode = (AnnotationNode)object.get(n);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n2, annotationNode.desc, false));
            }
        }
        n3 = this.attrs == null ? 0 : this.attrs.size();
        for (n2 = 0; n2 < n3; ++n2) {
            methodVisitor.visitAttribute((Attribute)this.attrs.get(n2));
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            for (n2 = 0; n2 < this.tryCatchBlocks.size(); ++n2) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(n2)).accept(methodVisitor);
            }
            this.instructions.accept(methodVisitor);
            n3 = this.localVariables == null ? 0 : this.localVariables.size();
            for (n2 = 0; n2 < n3; ++n2) {
                ((LocalVariableNode)this.localVariables.get(n2)).accept(methodVisitor);
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
        }
        methodVisitor.visitEnd();
    }
}

