/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class TraceableInterpretedMethod
extends InterpretedMethod {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private ISourcePosition position;
    private String name;

    public TraceableInterpretedMethod(RubyModule implementationClass, String name2, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, staticScope, body, argsNode, visibility, position);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.position = position;
        assert (argsNode != null);
    }

    protected void pre(ThreadContext context, String name2, IRubyObject self, Block block, Ruby runtime2) {
        context.preMethodFrameAndScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        if (runtime2.hasEventHooks()) {
            this.traceCall(context, runtime2, name2);
        }
    }

    protected void post(Ruby runtime2, ThreadContext context, String name2) {
        if (runtime2.hasEventHooks()) {
            this.traceReturn(context, runtime2, name2);
        }
        context.postMethodFrameAndScope();
    }

    private void traceReturn(ThreadContext context, Ruby runtime2, String name2) {
        runtime2.callEventHooks(context, RubyEvent.RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime2, String name2) {
        runtime2.callEventHooks(context, RubyEvent.CALL, this.position.getFile(), this.position.getStartLine(), name2, this.getImplementationClass());
    }

    public DynamicMethod dup() {
        return new TraceableInterpretedMethod(this.getImplementationClass(), this.name, this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

