/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

public class Position {
    public final int line;
    public final int column;
    public final int offset;

    public Position(int line, int column, int offset2) {
        this.line = line;
        this.column = column;
        this.offset = offset2;
    }

    public Position withLine(int line) {
        return new Position(line, this.column, this.offset);
    }

    public Position withColumn(int column) {
        return new Position(this.line, column, this.offset);
    }

    public Position withOffset(int offset2) {
        return new Position(this.line, this.column, offset2);
    }

    public boolean equals(Object other) {
        boolean res;
        boolean bl = res = this == other;
        if (!res && other instanceof Position) {
            Position o = (Position)other;
            res = this.line == o.line && this.column == o.column && this.offset == o.offset;
        }
        return res;
    }

    public String toString() {
        return "[" + this.line + ":" + this.column + "(" + this.offset + ")]";
    }

    public static class Range {
        public final Position start;
        public final Position end;

        public Range(Position start2) {
            this(start2, start2);
        }

        public Range(Position start2, Position end2) {
            this.start = start2;
            this.end = end2;
        }

        public Range withStart(Position start2) {
            return new Range(start2, this.end);
        }

        public Range withEnd(Position end2) {
            return new Range(this.start, end2);
        }

        public boolean equals(Object other) {
            boolean res;
            boolean bl = res = this == other;
            if (!res && other instanceof Range) {
                Range o = (Range)other;
                res = this.start.equals(o.start) && this.end.equals(o.end);
            }
            return res;
        }

        public String toString() {
            return "#<Range " + this.start + ":" + this.end + ">";
        }
    }
}

