/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import org.biojava.nbio.genome.App;
import org.biojava.nbio.genome.parsers.gff.LocIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Location
implements Iterable<Location> {
    private static final Logger logger = LoggerFactory.getLogger(App.class);
    private int mStart;
    private int mEnd;

    public Location(int start, int end) {
        this.mStart = start;
        this.mEnd = end;
        if (!this.isHealthy()) {
            throw new IllegalArgumentException("Improper location parameters: (" + start + "," + end + ")");
        }
    }

    public Location(Location other) {
        this.mStart = other.mStart;
        this.mEnd = other.mEnd;
        assert (this.isHealthy()) : this.toString();
    }

    public int getBegin() {
        if (this.isNegative()) {
            return this.mEnd;
        }
        return this.mStart;
    }

    public int getEnd() {
        if (this.isNegative()) {
            return this.mStart;
        }
        return this.mEnd;
    }

    public static Location fromBio(int start, int end, char strand) {
        int s = start - 1;
        int e = end;
        if (strand != '-' && strand != '+' && strand != '.') {
            throw new IllegalArgumentException("Strand must be '+', '-', or '.'");
        }
        if (strand == '-') {
            s = -end;
            e = -(start - 1);
        }
        return new Location(s, e);
    }

    public static Location fromBioExt(int start, int length, char strand, int totalLength) {
        int s = start;
        int e = s + length;
        if (strand != '-' && strand != '+' && strand != '.') {
            throw new IllegalArgumentException("Strand must be '+', '-', or '.'");
        }
        if (strand == '-') {
            s -= totalLength;
            e -= totalLength;
        }
        return new Location(s, e);
    }

    public char bioStrand() {
        return this.isNegative() ? (char)'-' : '+';
    }

    public int bioStart() {
        return this.plus().start() + 1;
    }

    public int bioEnd() {
        return this.plus().end();
    }

    public Location plus() {
        if (this.isNegative()) {
            return this.opposite();
        }
        return this;
    }

    public Location minus() {
        if (this.isNegative()) {
            return this;
        }
        return this.opposite();
    }

    public Location union(Location other) {
        if (!this.isSameStrand(other)) {
            throw new IllegalArgumentException("Locations are on opposite strands.");
        }
        int start = other.mStart < this.mStart ? other.mStart : this.mStart;
        int end = other.mEnd > this.mEnd ? other.mEnd : this.mEnd;
        return new Location(start, end);
    }

    public Location intersection(Location other) {
        if (this.isSameStrand(other)) {
            int end;
            int start = this.mStart > other.mStart ? this.mStart : other.mStart;
            int n = end = this.mEnd < other.mEnd ? this.mEnd : other.mEnd;
            if (start <= end) {
                return new Location(start, end);
            }
            return null;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public int start() {
        return this.mStart;
    }

    public int end() {
        return this.mEnd;
    }

    public int length() {
        return this.mEnd - this.mStart;
    }

    public Iterable<Location> window(final int windowSize, final int increment) {
        final Location loc = this;
        return new Iterable<Location>(){

            public LocIterator iterator() {
                return new LocIterator(loc, windowSize, increment);
            }
        };
    }

    public LocIterator iterator() {
        return new LocIterator(this, 1, 1);
    }

    public LocIterator iterator(int windowSize, int increment) {
        return new LocIterator(this, windowSize, increment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Location prefix(int position) {
        int end;
        if (position >= 0) {
            if (this.mStart + position > this.mEnd) throw new IndexOutOfBoundsException("Specified prefix longer than location.");
            end = this.mStart + position;
            return new Location(this.mStart, end);
        } else {
            if (this.mEnd + position <= this.mStart) throw new IndexOutOfBoundsException("Specified prefix longer than location.");
            end = this.mEnd + position;
        }
        return new Location(this.mStart, end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Location suffix(int position) {
        int start;
        if (position >= 0) {
            if (this.mStart + position > this.mEnd) throw new IndexOutOfBoundsException("Specified suffix longer than location.");
            start = this.mStart + position;
            return new Location(start, this.mEnd);
        } else {
            if (this.mEnd + position < this.mStart) throw new IndexOutOfBoundsException("Specified suffix longer than location.");
            start = this.mEnd + position;
        }
        return new Location(start, this.mEnd);
    }

    public Location prefix(Location other) {
        if (this.isSameStrand(other)) {
            if (other.mStart >= this.mStart) {
                return new Location(this.mStart, other.mStart < this.mEnd ? other.mStart : this.mEnd);
            }
            throw new IndexOutOfBoundsException("Specified location not within this location.");
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public Location suffix(Location other) {
        if (this.isSameStrand(other)) {
            if (other.mEnd <= this.mEnd) {
                return new Location(other.mEnd > this.mStart ? other.mEnd : this.mStart, this.mEnd);
            }
            throw new IndexOutOfBoundsException("Specified location not within this location.");
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public Location upstream(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Parameter must be >= 0; is=" + length);
        }
        if (Math.signum(this.mStart - length) == Math.signum(this.mStart) || 0.0f == Math.signum(this.mStart - length)) {
            return new Location(this.mStart - length, this.mStart);
        }
        throw new IndexOutOfBoundsException("Specified length causes crossing of origin: " + length + "; " + this.toString());
    }

    public Location downstream(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Parameter must be >= 0; is=" + length);
        }
        if (Math.signum(this.mEnd + length) == Math.signum(this.mEnd) || 0.0f == Math.signum(this.mEnd + length)) {
            return new Location(this.mEnd, this.mEnd + length);
        }
        throw new IndexOutOfBoundsException("Specified length causes crossing of origin: " + length + "; " + this.toString());
    }

    public int distance(Location other) {
        if (this.isSameStrand(other)) {
            if (this.overlaps(other)) {
                return -1;
            }
            return this.mEnd <= other.mStart ? other.mStart - this.mEnd : this.mStart - other.mEnd;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public double percentOverlap(Location other) {
        if (this.length() > 0 && this.overlaps(other)) {
            return 100.0 * ((double)this.intersection(other).length() / (double)this.length());
        }
        return 0.0;
    }

    public boolean overlaps(Location other) {
        if (this.isSameStrand(other)) {
            return this.mStart < other.mEnd && this.mEnd > other.mStart;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public boolean contains(Location other) {
        if (this.isSameStrand(other)) {
            return this.mStart <= other.mStart && this.mEnd >= other.mEnd;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public boolean startsAfter(Location other) {
        if (this.isSameStrand(other)) {
            return this.mStart > other.mStart;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public boolean startsBefore(Location other) {
        if (this.isSameStrand(other)) {
            return this.mStart < other.mStart;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public boolean endsAfter(Location other) {
        if (this.isSameStrand(other)) {
            return this.mEnd > other.mEnd;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public boolean endsBefore(Location other) {
        if (this.isSameStrand(other)) {
            return this.mEnd < other.mEnd;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public boolean isAfter(Location other) {
        if (this.isSameStrand(other)) {
            return this.mStart >= other.mEnd;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public boolean isBefore(Location other) {
        if (this.isSameStrand(other)) {
            return this.mEnd <= other.mStart;
        }
        throw new IllegalArgumentException("Locations are on opposite strands.");
    }

    public boolean isNegative() {
        return this.mStart <= 0 && this.mEnd <= 0;
    }

    public Location opposite() {
        return new Location(-this.mEnd, -this.mStart);
    }

    public boolean isSameStrand(Location other) {
        return this.isNegative() && other.isNegative() || !this.isNegative() && !other.isNegative();
    }

    public String toString() {
        return new String("[L=" + (this.mEnd - this.mStart) + "; S=" + this.mStart + "; E=" + this.mEnd + "]");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mEnd;
        result = 31 * result + this.mStart;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.mEnd != other.mEnd) {
            return false;
        }
        return this.mStart == other.mStart;
    }

    private boolean isHealthy() {
        return this.mStart <= this.mEnd && (this.mStart <= 0 && this.mEnd <= 0 || this.mStart >= 0 && this.mEnd >= 0);
    }

    private static Location L(int s, int e) {
        return new Location(s, e);
    }

    private static Location R(int s, int e) {
        return new Location(-e, -s);
    }

    @Deprecated
    public static void main(String[] args) throws Exception {
        Location p3_7 = new Location(3, 7);
        Location p16_19 = new Location(16, 19);
        Location p15_19 = new Location(15, 19);
        Location p15_16 = new Location(15, 16);
        Location p10_17 = new Location(10, 17);
        Location p10_12 = new Location(10, 12);
        Location p14_17 = new Location(14, 17);
        Location p14_14 = new Location(14, 14);
        Location r13_17 = new Location(13, 17);
        Location r21_25 = new Location(21, 25);
        Location r4_7 = new Location(4, 7);
        Location r2_5 = new Location(2, 5);
        Location r0_3 = new Location(0, 3);
        Location r5_8 = new Location(5, 8);
        assert (Location.L(14, 14).distance(Location.L(3, 7)) == 7);
        assert (Location.L(3, 7).distance(Location.L(14, 14)) == 7);
        assert (Location.L(1, 4).distance(Location.L(7, 10)) == 3);
        assert (p10_12.union(p14_17).equals(p10_17));
        assert (p14_17.union(p10_12).equals(p10_17));
        assert (p15_19.union(p15_16).equals(p15_19));
        assert (r13_17.union(r21_25).intersection(r21_25).equals(new Location(21, 25)));
        assert (r2_5.isBefore(r5_8));
        assert (!r2_5.isBefore(r4_7));
        assert (r5_8.isAfter(r2_5));
        assert (!r5_8.isAfter(r4_7));
        assert (p15_19.contains(p16_19));
        assert (r2_5.overlaps(r4_7));
        assert (r2_5.overlaps(r0_3));
        assert (!r5_8.overlaps(r2_5));
        assert (!r2_5.overlaps(r5_8));
        assert (Location.L(2, 20).prefix(1).equals(Location.L(2, 3)));
        assert (Location.L(2, 20).prefix(-1).equals(Location.L(2, 19)));
        assert (Location.L(2, 20).prefix(Location.L(10, 12)).equals(Location.L(2, 10)));
        assert (Location.L(2, 20).suffix(1).equals(Location.L(3, 20)));
        assert (Location.L(2, 20).suffix(-1).equals(Location.L(19, 20)));
        assert (Location.L(2, 20).suffix(Location.L(10, 12)).equals(Location.L(12, 20)));
        logger.info("JavaGene.Location Passed.");
    }
}

