/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.genename;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.genome.App;
import org.biojava.nbio.genome.parsers.genename.GeneChromosomePosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneChromosomePositionParser {
    private static final Logger logger = LoggerFactory.getLogger(App.class);
    public static final String DEFAULT_MAPPING_URL = "http://hgdownload.cse.ucsc.edu/goldenPath/hg19/database/refFlat.txt.gz";

    public static void main(String[] args) {
        try {
            List<GeneChromosomePosition> genePositions = GeneChromosomePositionParser.getChromosomeMappings();
            logger.info("got {} gene positions", (Object)genePositions.size());
            for (GeneChromosomePosition pos : genePositions) {
                if (!"FOLH1".equals(pos.getGeneName())) continue;
                logger.info("Gene Position: {}", (Object)pos);
                break;
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public static List<GeneChromosomePosition> getChromosomeMappings() throws IOException {
        URL url = new URL(DEFAULT_MAPPING_URL);
        InputStreamProvider prov = new InputStreamProvider();
        InputStream inStream = prov.getInputStream(url);
        return GeneChromosomePositionParser.getChromosomeMappings(inStream);
    }

    public static List<GeneChromosomePosition> getChromosomeMappings(InputStream inStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        ArrayList<GeneChromosomePosition> gcps = new ArrayList<GeneChromosomePosition>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            GeneChromosomePosition gcp = GeneChromosomePositionParser.getGeneChromosomePosition(line);
            if (gcp == null) continue;
            gcps.add(gcp);
        }
        gcps.trimToSize();
        return gcps;
    }

    private static GeneChromosomePosition getGeneChromosomePosition(String line) {
        if (line == null) {
            return null;
        }
        String[] spl = line.split("\t");
        if (spl.length != 11) {
            logger.warn("Line does not have 11 data items, but {}: {}", (Object)spl.length, (Object)line);
            return null;
        }
        GeneChromosomePosition g = new GeneChromosomePosition();
        g.setGeneName(spl[0]);
        g.setGenebankId(spl[1]);
        g.setChromosome(spl[2]);
        g.setOrientation(Character.valueOf(spl[3].charAt(0)));
        g.setTranscriptionStart(Integer.parseInt(spl[4]));
        g.setTranscriptionEnd(Integer.parseInt(spl[5]));
        g.setCdsStart(Integer.parseInt(spl[6]));
        g.setCdsEnd(Integer.parseInt(spl[7]));
        g.setExonCount(Integer.parseInt(spl[8]));
        String exonStarts = spl[9];
        String exonEnds = spl[10];
        g.setExonStarts(GeneChromosomePositionParser.getIntegerList(exonStarts));
        g.setExonEnds(GeneChromosomePositionParser.getIntegerList(exonEnds));
        return g;
    }

    private static List<Integer> getIntegerList(String lst) {
        String[] spl = lst.split(",");
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (String s : spl) {
            l.add(Integer.parseInt(s));
        }
        l.trimToSize();
        return l;
    }
}

