/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.Rotation;

public class RotationGroup {
    private List<Rotation> rotations = new ArrayList<Rotation>();
    private int principalAxisIndex = 0;
    private int higherOrderRotationAxis = 0;
    private int twoFoldsPerpendicular = 0;
    private int highestOrder = 0;
    private String pointGroup = "C1";
    private double symmetryDeviation = 0.0;
    private boolean complete = true;
    private boolean modified = true;

    public int getOrder() {
        return this.rotations.size();
    }

    public Rotation getRotation(int index) {
        return this.rotations.get(index);
    }

    public void addRotation(Rotation rotation) {
        this.rotations.add(rotation);
        this.modified = true;
    }

    public void setC1(int n) {
        Rotation r = new Rotation();
        ArrayList<Integer> permutation = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            permutation.add(i);
        }
        r.setPermutation(permutation);
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        r.setTransformation(m);
        r.setAxisAngle(new AxisAngle4d());
        r.setFold(1);
        r.setScores(new QuatSymmetryScores());
        this.rotations.add(r);
        this.pointGroup = "C1";
    }

    public void removeRotation(int index) {
        this.rotations.remove(index);
        this.modified = true;
    }

    public void complete() {
        if (this.modified) {
            if (this.rotations.size() > 0) {
                this.findHighestOrderAxis();
                this.setEAxis();
                this.calcAxesDirections();
                this.findHigherOrderAxes();
                this.findTwoFoldsPerpendicular();
                this.calcPointGroup();
                this.sortByFoldDecending();
            }
            this.modified = false;
        }
    }

    public String getPointGroup() {
        if (this.modified) {
            if (this.rotations.size() == 0) {
                return "C1";
            }
            this.complete();
        }
        return this.pointGroup;
    }

    public QuatSymmetryScores getScores() {
        QuatSymmetryScores scores = new QuatSymmetryScores();
        int n = this.rotations.size() - 1;
        if (n > 0) {
            int i;
            double[] values = new double[n];
            for (i = 1; i < this.rotations.size(); ++i) {
                values[i - 1] = this.rotations.get(i).getScores().getMinRmsd();
            }
            scores.setMinRmsd(this.minScores(values));
            for (i = 1; i < this.rotations.size(); ++i) {
                values[i - 1] = this.rotations.get(i).getScores().getMaxRmsd();
            }
            scores.setMaxRmsd(this.maxScores(values));
            for (i = 1; i < this.rotations.size(); ++i) {
                values[i - 1] = this.rotations.get(i).getScores().getRmsd();
            }
            scores.setRmsd(this.averageScores(values));
            for (i = 1; i < this.rotations.size(); ++i) {
                values[i - 1] = this.rotations.get(i).getScores().getMinTm();
            }
            scores.setMinTm(this.minScores(values));
            for (i = 1; i < this.rotations.size(); ++i) {
                values[i - 1] = this.rotations.get(i).getScores().getMaxTm();
            }
            scores.setMaxTm(this.maxScores(values));
            for (i = 1; i < this.rotations.size(); ++i) {
                values[i - 1] = this.rotations.get(i).getScores().getTm();
            }
            scores.setTm(this.averageScores(values));
            for (i = 1; i < this.rotations.size(); ++i) {
                values[i - 1] = this.rotations.get(i).getScores().getRmsdCenters();
            }
            scores.setRmsdCenters(this.averageScores(values));
            for (i = 1; i < this.rotations.size(); ++i) {
                values[i - 1] = this.rotations.get(i).getScores().getTmIntra();
            }
            scores.setTmIntra(this.averageScores(values));
            for (i = 1; i < this.rotations.size(); ++i) {
                values[i - 1] = this.rotations.get(i).getScores().getRmsdIntra();
            }
            scores.setRmsdIntra(this.averageScores(values));
            scores.setSymDeviation(this.symmetryDeviation);
        }
        return scores;
    }

    public void setSymmetryDeviation(double symmetryDeviation) {
        this.symmetryDeviation = symmetryDeviation;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rotations: " + this.rotations.size() + "\n");
        for (Rotation s : this.rotations) {
            sb.append(s.toString() + "\n");
        }
        return sb.toString();
    }

    private double averageScores(double[] scores) {
        double sum = 0.0;
        for (double s : scores) {
            sum += s;
        }
        return sum / (double)scores.length;
    }

    private double minScores(double[] scores) {
        double score = Double.MAX_VALUE;
        for (double s : scores) {
            score = Math.min(score, s);
        }
        return score;
    }

    private double maxScores(double[] scores) {
        double score = Double.MIN_VALUE;
        for (double s : scores) {
            score = Math.max(score, s);
        }
        return score;
    }

    private void findHighestOrderAxis() {
        this.highestOrder = 1;
        this.principalAxisIndex = 0;
        double rmsd = Double.MAX_VALUE;
        for (int i = 0; i < this.rotations.size(); ++i) {
            Rotation s = this.rotations.get(i);
            if (s.getFold() > this.highestOrder) {
                this.highestOrder = s.getFold();
                this.principalAxisIndex = i;
                rmsd = s.getTraceRmsd();
                continue;
            }
            if (s.getFold() < this.highestOrder || !(s.getTraceRmsd() < rmsd)) continue;
            this.highestOrder = s.getFold();
            this.principalAxisIndex = i;
            rmsd = s.getTraceRmsd();
        }
    }

    private void setEAxis() {
        Rotation e = this.rotations.get(0);
        Rotation h = this.rotations.get(this.principalAxisIndex);
        e.setAxisAngle(new AxisAngle4d(h.getAxisAngle()));
        e.getAxisAngle().angle = 0.0;
        e.setFold(h.getFold());
    }

    private void findHigherOrderAxes() {
        this.higherOrderRotationAxis = 0;
        for (Rotation s : this.rotations) {
            if (s.getFold() <= 2 || s.getDirection() != 1) continue;
            ++this.higherOrderRotationAxis;
        }
    }

    private void calcAxesDirections() {
        if (this.highestOrder == 1) {
            for (Rotation s : this.rotations) {
                s.setDirection(0);
            }
            return;
        }
        AxisAngle4d pa = this.rotations.get(this.principalAxisIndex).getAxisAngle();
        Vector3d pv = new Vector3d(pa.x, pa.y, pa.z);
        for (Rotation s : this.rotations) {
            AxisAngle4d axis = s.getAxisAngle();
            Vector3d av = new Vector3d(axis.x, axis.y, axis.z);
            if (Math.abs(pv.dot(av)) > (double)0.9f) {
                s.setDirection(0);
                continue;
            }
            s.setDirection(1);
        }
        this.rotations.get(0).setDirection(0);
    }

    private void findTwoFoldsPerpendicular() {
        this.twoFoldsPerpendicular = 0;
        for (Rotation s : this.rotations) {
            if (s.getFold() != 2 || s.getDirection() != 1) continue;
            ++this.twoFoldsPerpendicular;
        }
    }

    public int getHigherOrderRotationAxis() {
        return this.higherOrderRotationAxis;
    }

    public int getTwoFoldsPerpendicular() {
        return this.twoFoldsPerpendicular;
    }

    public int getPrincipalAxisIndex() {
        return this.principalAxisIndex;
    }

    private void calcPointGroup() {
        this.complete = false;
        if (this.higherOrderRotationAxis > 1) {
            if (this.highestOrder == 5) {
                this.pointGroup = "I";
                this.complete = this.rotations.size() == 60;
            } else if (this.highestOrder == 4) {
                this.pointGroup = "O";
                this.complete = this.rotations.size() == 24;
            } else if (this.highestOrder == 3) {
                this.pointGroup = "T";
                this.complete = this.rotations.size() == 12;
            }
        } else if (Math.abs(this.twoFoldsPerpendicular - this.highestOrder) <= 1 && this.highestOrder > 1) {
            this.pointGroup = "D" + this.highestOrder;
            this.complete = this.rotations.size() == 2 * this.highestOrder;
        } else {
            this.pointGroup = "C" + this.highestOrder;
            boolean bl = this.complete = this.rotations.size() == this.highestOrder;
        }
        if (!this.complete) {
            int n = 0;
            if (this.rotations.size() > 0) {
                n = this.rotations.get(0).getPermutation().size();
                this.rotations.clear();
            }
            this.setC1(n);
        }
    }

    public void sortByFoldDecending() {
        Collections.sort(this.rotations, new Comparator<Rotation>(){

            @Override
            public int compare(Rotation o1, Rotation o2) {
                int delta = o1.getDirection() - o2.getDirection();
                if (delta != 0) {
                    return delta;
                }
                delta = Math.round(Math.signum(o2.getFold() - o1.getFold()));
                if (delta != 0) {
                    return delta;
                }
                delta = (int)Math.signum(o1.getAxisAngle().angle - o2.getAxisAngle().angle);
                return delta;
            }
        });
    }
}

