/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.PDBRecord;

public class Site
implements PDBRecord,
Comparable<Site> {
    private static final long serialVersionUID = -4577047072916341237L;
    private static final String lineEnd = System.getProperty("line.separator");
    private String siteID = "";
    private List<Group> groups = new ArrayList<Group>();
    private String evCode = "";
    private String description = "";

    public Site() {
    }

    public Site(String siteID, List<Group> groups) {
        this.siteID = siteID;
        this.groups = groups;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SITE ");
        stringBuilder.append(this.siteID).append(" ").append(this.groups.size()).append(" ");
        for (Group group : this.groups) {
            String groupString = String.format("%s %s", group.getPDBName(), group.getResidueNumber().toPDB());
            stringBuilder.append(groupString);
        }
        stringBuilder.append(lineEnd);
        return stringBuilder.toString();
    }

    @Override
    public String toPDB() {
        StringBuffer buffer = new StringBuffer();
        this.toPDB(buffer);
        return buffer.toString();
    }

    @Override
    public void toPDB(StringBuffer buf) {
        if (this.groups == null || this.groups.size() < 1) {
            return;
        }
        int seqNum = 0;
        int groupsWritten = 0;
        int groupNum = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (groupsWritten < this.groups.size()) {
            StringBuilder groupsString = new StringBuilder();
            for (int i = 0; i < 4 && groupsWritten < this.groups.size(); ++i) {
                Group group = this.groups.get(groupNum);
                String groupString = String.format(Locale.UK, "%3s %s", group.getPDBName(), group.getResidueNumber().toPDB());
                ++groupNum;
                if (i == 3 || ++groupsWritten == this.groups.size()) {
                    groupString.replaceFirst("\\s+$", "");
                }
                groupsString.append(groupString);
            }
            stringBuilder.append(String.format(Locale.UK, "SITE   %3d %3s %2d %-62s", seqNum + 1, this.siteID, this.groups.size(), groupsString.toString()));
            ++seqNum;
            stringBuilder.append(lineEnd);
        }
        buf.append((CharSequence)stringBuilder);
    }

    public void remark800toPDB(StringBuffer stringBuffer) {
        stringBuffer.append(String.format(Locale.UK, "REMARK 800 SITE_IDENTIFIER: %-52s%s", this.siteID, lineEnd));
        stringBuffer.append(String.format(Locale.UK, "REMARK 800 EVIDENCE_CODE: %-54s%s", this.evCode, lineEnd));
        stringBuffer.append(String.format(Locale.UK, "REMARK 800 SITE_DESCRIPTION: %-51s%s", this.description, lineEnd));
    }

    public String remark800toPDB() {
        StringBuffer stringBuffer = new StringBuffer();
        this.remark800toPDB(stringBuffer);
        return stringBuffer.toString();
    }

    public void setSiteID(String siteID) {
        this.siteID = siteID;
    }

    public String getSiteID() {
        return this.siteID;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> residues) {
        this.groups = residues;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEvCode() {
        return this.evCode;
    }

    public void setEvCode(String evCode) {
        this.evCode = evCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Site other = (Site)obj;
        if (this.siteID == null ? other.siteID != null : !this.siteID.equals(other.siteID)) {
            return false;
        }
        if (!(this.groups == other.groups || this.groups != null && this.groups.equals(other.groups))) {
            return false;
        }
        if (this.evCode == null ? other.evCode != null : !this.evCode.equals(other.evCode)) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.siteID != null ? this.siteID.hashCode() : 0);
        hash = 37 * hash + (this.groups != null ? this.groups.hashCode() : 0);
        hash = 37 * hash + (this.evCode != null ? this.evCode.hashCode() : 0);
        hash = 37 * hash + (this.description != null ? this.description.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(Site other) {
        return this.toString().compareTo(other.toString());
    }
}

