/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.MMCIFFileReader;
import org.biojava.nbio.structure.io.PDBFileReader;

public class StructureIO {
    private static AtomCache cache;
    private static final String FILE_SEPARATOR;

    public static Structure getStructure(String name) throws IOException, StructureException {
        StructureIO.checkInitAtomCache();
        return cache.getStructure(name);
    }

    private static void checkInitAtomCache() {
        if (cache == null) {
            cache = new AtomCache();
        }
    }

    public static void setAtomCache(AtomCache c) {
        cache = c;
    }

    public static Structure getBiologicalAssembly(String pdbId, boolean multiModel) throws IOException, StructureException {
        StructureIO.checkInitAtomCache();
        pdbId = pdbId.toLowerCase();
        Structure s = cache.getBiologicalAssembly(pdbId, multiModel);
        return s;
    }

    public static Structure getBiologicalAssembly(String pdbId) throws IOException, StructureException {
        return StructureIO.getBiologicalAssembly(pdbId, false);
    }

    public static Structure getBiologicalAssembly(String pdbId, int biolAssemblyNr, boolean multiModel) throws IOException, StructureException {
        StructureIO.checkInitAtomCache();
        pdbId = pdbId.toLowerCase();
        Structure s = cache.getBiologicalAssembly(pdbId, biolAssemblyNr, multiModel);
        return s;
    }

    public static Structure getBiologicalAssembly(String pdbId, int biolAssemblyNr) throws IOException, StructureException {
        return StructureIO.getBiologicalAssembly(pdbId, biolAssemblyNr, false);
    }

    public static List<Structure> getBiologicalAssemblies(String pdbId, boolean multiModel) throws IOException, StructureException {
        StructureIO.checkInitAtomCache();
        pdbId = pdbId.toLowerCase();
        List<Structure> s = cache.getBiologicalAssemblies(pdbId, multiModel);
        return s;
    }

    public static List<Structure> getBiologicalAssemblies(String pdbId) throws IOException, StructureException {
        return StructureIO.getBiologicalAssemblies(pdbId, false);
    }

    public static void setPdbPath(String pathToPDBFiles) {
        if (!pathToPDBFiles.endsWith(FILE_SEPARATOR)) {
            pathToPDBFiles = pathToPDBFiles + FILE_SEPARATOR;
        }
    }

    public static StructureFiletype guessFiletype(String filename) {
        String lower = filename.toLowerCase();
        for (StructureFiletype type : StructureFiletype.values()) {
            for (String ext : type.getExtensions()) {
                if (!lower.endsWith(ext.toLowerCase())) continue;
                return type;
            }
        }
        return StructureFiletype.UNKNOWN;
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
    }

    public static enum StructureFiletype {
        PDB(new PDBFileReader().getExtensions()),
        CIF(new MMCIFFileReader().getExtensions()),
        UNKNOWN(Collections.emptyList());

        private List<String> extensions;

        private StructureFiletype(List<String> extensions) {
            this.extensions = extensions;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }
    }
}

