/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.ClusterAltAligs;
import org.biojava.nbio.structure.align.StrucAligParameters;
import org.biojava.nbio.structure.align.ce.GuiWrapper;
import org.biojava.nbio.structure.align.helper.AlignTools;
import org.biojava.nbio.structure.align.helper.JointFragments;
import org.biojava.nbio.structure.align.pairwise.AlignmentProgressListener;
import org.biojava.nbio.structure.align.pairwise.AltAligComparator;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.nbio.structure.align.pairwise.FragmentJoiner;
import org.biojava.nbio.structure.align.pairwise.FragmentPair;
import org.biojava.nbio.structure.geometry.Matrices;
import org.biojava.nbio.structure.geometry.SuperPositions;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.biojava.nbio.structure.jama.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructurePairAligner {
    private static final Logger logger = LoggerFactory.getLogger(StructurePairAligner.class);
    AlternativeAlignment[] alts;
    Matrix distanceMatrix;
    StrucAligParameters params;
    FragmentPair[] fragPairs;
    List<AlignmentProgressListener> listeners = new ArrayList<AlignmentProgressListener>();

    public StructurePairAligner() {
        this.params = StrucAligParameters.getDefaultParameters();
        this.reset();
        this.alts = new AlternativeAlignment[0];
        this.distanceMatrix = new Matrix(0, 0);
    }

    public void addProgressListener(AlignmentProgressListener li) {
        this.listeners.add(li);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public static void main(String[] args) throws Exception {
        PDBFileReader pdbr = new PDBFileReader();
        pdbr.setPath("/Users/andreas/WORK/PDB/");
        String pdb1 = "1buz";
        String pdb2 = "1ali";
        String outputfile = "/tmp/alig_" + pdb1 + "_" + pdb2 + ".pdb";
        StructurePairAligner sc = new StructurePairAligner();
        logger.info("aligning {} vs. {}", (Object)pdb1, (Object)pdb2);
        Structure s1 = pdbr.getStructureById(pdb1);
        Structure s2 = pdbr.getStructureById(pdb2);
        sc.align(s1, s2);
        AlternativeAlignment[] aligs = sc.getAlignments();
        ClusterAltAligs.cluster(aligs);
        for (AlternativeAlignment aa : aligs) {
            logger.info("Alternative Alignment: ", (Object)aa);
        }
        if (aligs.length > 0) {
            AlternativeAlignment aa1 = aligs[0];
            String pdbstr = aa1.toPDB(s1, s2);
            logger.info("writing alignment to {}", (Object)outputfile);
            FileOutputStream out = new FileOutputStream(outputfile);
            PrintStream p = new PrintStream(out);
            p.println(pdbstr);
            p.close();
            out.close();
        }
        if (aligs.length > 0 && !GuiWrapper.isGuiModuleInstalled()) {
            logger.error("Could not find structure-gui modules in classpath, please install first!");
        }
    }

    private void reset() {
        this.alts = new AlternativeAlignment[0];
        this.distanceMatrix = new Matrix(0, 0);
        this.fragPairs = new FragmentPair[0];
    }

    public FragmentPair[] getFragmentPairs() {
        return this.fragPairs;
    }

    public void setFragmentPairs(FragmentPair[] fragPairs) {
        this.fragPairs = fragPairs;
    }

    public AlternativeAlignment[] getAlignments() {
        return this.alts;
    }

    public Matrix getDistMat() {
        return this.distanceMatrix;
    }

    public StrucAligParameters getParams() {
        return this.params;
    }

    public void setParams(StrucAligParameters params) {
        this.params = params;
    }

    @Deprecated
    public boolean isDebug() {
        return false;
    }

    @Deprecated
    public void setDebug(boolean debug) {
    }

    public void align(Structure s1, Structure s2) throws StructureException {
        this.align(s1, s2, this.params);
    }

    public void align(Structure s1, Structure s2, StrucAligParameters params) throws StructureException {
        Atom[] ca1 = this.getAlignmentAtoms(s1);
        Atom[] ca2 = this.getAlignmentAtoms(s2);
        this.notifyStartingAlignment(s1.getName(), ca1, s2.getName(), ca2);
        this.align(ca1, ca2, params);
    }

    public void align(Structure s1, String chainId1, Structure s2, String chainId2) throws StructureException {
        this.align(s1, chainId1, s2, chainId2, this.params);
    }

    public void align(Structure s1, String chainId1, Structure s2, String chainId2, StrucAligParameters params) throws StructureException {
        this.reset();
        this.params = params;
        Chain c1 = s1.getPolyChainByPDB(chainId1);
        Chain c2 = s2.getPolyChainByPDB(chainId2);
        StructureImpl s3 = new StructureImpl();
        s3.addChain(c1);
        StructureImpl s4 = new StructureImpl();
        s4.addChain(c2);
        Atom[] ca1 = this.getAlignmentAtoms(s3);
        Atom[] ca2 = this.getAlignmentAtoms(s4);
        this.notifyStartingAlignment(s1.getName(), ca1, s2.getName(), ca2);
        this.align(ca1, ca2, params);
    }

    public Atom[] getAlignmentAtoms(Structure s) {
        String[] atomNames = this.params.getUsedAtomNames();
        return StructureTools.getAtomArray(s, atomNames);
    }

    public void align(Atom[] ca1, Atom[] ca2, StrucAligParameters params) throws StructureException {
        JointFragments[] frags;
        this.reset();
        this.params = params;
        long timeStart = System.currentTimeMillis();
        logger.debug(" length atoms1:" + ca1.length);
        logger.debug(" length atoms2:" + ca2.length);
        logger.debug("step 1 - get fragments with similar intramolecular distances ");
        int k = params.getDiagonalDistance();
        int k2 = params.getDiagonalDistance2();
        int fragmentLength = params.getFragmentLength();
        if (ca1.length < fragmentLength + 1) {
            throw new StructureException("structure 1 too short (" + ca1.length + "), can not align");
        }
        if (ca2.length < fragmentLength + 1) {
            throw new StructureException("structure 2 too short (" + ca2.length + "), can not align");
        }
        int rows = ca1.length - fragmentLength + 1;
        int cols = ca2.length - fragmentLength + 1;
        this.distanceMatrix = new Matrix(rows, cols, 0.0);
        double[] dist1 = AlignTools.getDiagonalAtK(ca1, k);
        double[] dist2 = AlignTools.getDiagonalAtK(ca2, k);
        double[] dist3 = new double[]{};
        double[] dist4 = new double[]{};
        if (k2 > 0) {
            dist3 = AlignTools.getDiagonalAtK(ca1, k2);
            dist4 = AlignTools.getDiagonalAtK(ca2, k2);
        }
        double[][] utmp = new double[][]{{0.0, 0.0, 1.0}};
        AtomImpl unitvector = new AtomImpl();
        unitvector.setCoords(utmp[0]);
        ArrayList<FragmentPair> fragments = new ArrayList<FragmentPair>();
        for (int i = 0; i < rows; ++i) {
            Atom[] catmp1 = AlignTools.getFragment(ca1, i, fragmentLength);
            Atom center1 = AlignTools.getCenter(ca1, i, fragmentLength);
            for (int j = 0; j < cols; ++j) {
                double rdd1 = AlignTools.rms_dk_diag(dist1, dist2, i, j, fragmentLength, k);
                double rdd2 = 0.0;
                if (k2 > 0) {
                    rdd2 = AlignTools.rms_dk_diag(dist3, dist4, i, j, fragmentLength, k2);
                }
                double rdd = rdd1 + rdd2;
                this.distanceMatrix.set(i, j, rdd);
                if (!(rdd < (double)params.getFragmentMiniDistance())) continue;
                FragmentPair f = new FragmentPair(fragmentLength, i, j);
                Atom[] catmp2 = AlignTools.getFragment(ca2, j, fragmentLength);
                Atom center2 = AlignTools.getCenter(ca2, j, fragmentLength);
                f.setCenter1(center1);
                f.setCenter2(center2);
                Matrix4d t = SuperPositions.superpose(Calc.atomsToPoints(catmp1), Calc.atomsToPoints(catmp2));
                Matrix rotmat = Matrices.getRotationJAMA(t);
                f.setRot(rotmat);
                Atom aunitv = (Atom)unitvector.clone();
                Calc.rotate(aunitv, rotmat);
                f.setUnitv(aunitv);
                boolean doNotAdd = false;
                if (params.reduceInitialFragments()) {
                    doNotAdd = FragmentJoiner.reduceFragments(fragments, f, this.distanceMatrix);
                }
                if (doNotAdd) continue;
                fragments.add(f);
            }
        }
        this.notifyFragmentListeners(fragments);
        FragmentPair[] fp = fragments.toArray(new FragmentPair[fragments.size()]);
        this.setFragmentPairs(fp);
        logger.debug(" got # fragment pairs: {}", (Object)fp.length);
        logger.debug("step 2 - join fragments");
        FragmentJoiner joiner = new FragmentJoiner();
        if (params.isJoinFast()) {
            frags = joiner.approach_ap3(ca1, ca2, fp, params);
            joiner.extendFragments(ca1, ca2, frags, params);
        } else {
            frags = params.isJoinPlo() ? joiner.frag_pairwise_compat(fp, params.getAngleDiff(), params.getFragCompat(), params.getMaxrefine()) : joiner.approach_ap3(ca1, ca2, fp, params);
        }
        this.notifyJointFragments(frags);
        logger.debug(" number joint fragments: ", (Object)frags.length);
        logger.debug("step 3 - refine alignments");
        ArrayList<AlternativeAlignment> aas = new ArrayList<AlternativeAlignment>();
        for (int i = 0; i < frags.length; ++i) {
            JointFragments f = frags[i];
            AlternativeAlignment a = new AlternativeAlignment();
            a.apairs_from_idxlst(f);
            a.setAltAligNumber(i + 1);
            a.setDistanceMatrix(this.distanceMatrix);
            try {
                if (params.getMaxIter() > 0) {
                    a.refine(params, ca1, ca2);
                } else {
                    a.finish(params, ca1, ca2);
                }
            }
            catch (StructureException e) {
                logger.error("Refinement of fragment {} failed", (Object)i, (Object)e);
            }
            a.calcScores(ca1, ca2);
            aas.add(a);
        }
        AltAligComparator comp = new AltAligComparator();
        Collections.sort(aas, comp);
        Collections.reverse(aas);
        this.alts = aas.toArray(new AlternativeAlignment[aas.size()]);
        int aanbr = 0;
        for (AlternativeAlignment a : this.alts) {
            a.setAltAligNumber(++aanbr);
        }
        logger.debug("total calculation time: {} ms.", (Object)(System.currentTimeMillis() - timeStart));
    }

    private void notifyStartingAlignment(String name1, Atom[] ca1, String name2, Atom[] ca2) {
        for (AlignmentProgressListener li : this.listeners) {
            li.startingAlignment(name1, ca1, name2, ca2);
        }
    }

    private void notifyFragmentListeners(List<FragmentPair> fragments) {
        for (AlignmentProgressListener li : this.listeners) {
            li.calculatedFragmentPairs(fragments);
        }
    }

    private void notifyJointFragments(JointFragments[] fragments) {
        for (AlignmentProgressListener li : this.listeners) {
            li.jointFragments(fragments);
        }
    }
}

