/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.client.StructureName;
import org.biojava.nbio.structure.align.helper.AlignTools;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.AbstractScoresCache;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.jama.Matrix;

public class MultipleAlignmentEnsembleImpl
extends AbstractScoresCache
implements MultipleAlignmentEnsemble,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5732485866623431898L;
    private String algorithmName;
    private String version;
    private Long ioTime;
    private Long calculationTime;
    private List<StructureIdentifier> structureIdentifiers;
    private List<Atom[]> atomArrays;
    private List<Matrix> distanceMatrix;
    private List<MultipleAlignment> multipleAlignments;

    public MultipleAlignmentEnsembleImpl() {
        this.algorithmName = null;
        this.version = null;
        this.ioTime = null;
        this.calculationTime = null;
        this.structureIdentifiers = null;
        this.atomArrays = null;
        this.distanceMatrix = null;
        this.multipleAlignments = null;
    }

    public MultipleAlignmentEnsembleImpl(List<StructureIdentifier> structureIdentifiers) {
        this();
        this.setStructureIdentifiers(structureIdentifiers);
    }

    public MultipleAlignmentEnsembleImpl(MultipleAlignmentEnsembleImpl e) {
        super(e);
        this.algorithmName = e.algorithmName;
        this.version = e.version;
        this.ioTime = e.ioTime;
        this.calculationTime = e.calculationTime;
        this.distanceMatrix = null;
        if (e.distanceMatrix != null) {
            this.distanceMatrix = new ArrayList<Matrix>();
            for (Matrix mat : e.distanceMatrix) {
                this.distanceMatrix.add((Matrix)mat.clone());
            }
        }
        this.multipleAlignments = null;
        if (e.multipleAlignments != null) {
            this.multipleAlignments = new ArrayList<MultipleAlignment>();
            for (MultipleAlignment msa : e.multipleAlignments) {
                MultipleAlignment newMSA = msa.clone();
                newMSA.setEnsemble(this);
                this.multipleAlignments.add(newMSA);
            }
        }
        if (e.atomArrays != null) {
            this.atomArrays = new ArrayList<Atom[]>(e.atomArrays);
        }
        if (e.structureIdentifiers != null) {
            this.structureIdentifiers = new ArrayList<StructureIdentifier>(e.structureIdentifiers);
        }
    }

    public MultipleAlignmentEnsembleImpl(AFPChain afp, Atom[] ca1, Atom[] ca2, boolean flexible) {
        this();
        this.atomArrays = Arrays.asList(ca1, ca2);
        if (afp.getName1() != null && !afp.getName1().isEmpty() && afp.getName2() != null && !afp.getName2().isEmpty()) {
            this.structureIdentifiers = Arrays.asList(new StructureName(afp.getName1()), new StructureName(afp.getName2()));
        }
        this.algorithmName = afp.getAlgorithmName();
        this.version = afp.getVersion();
        this.calculationTime = afp.getCalculationTime();
        MultipleAlignmentImpl msa = new MultipleAlignmentImpl(this);
        this.setMultipleAlignments(Arrays.asList(msa));
        Matrix4d ident = new Matrix4d();
        ident.setIdentity();
        Matrix[] rot = afp.getBlockRotationMatrix();
        Atom[] shift = afp.getBlockShiftVector();
        if (flexible) {
            for (int bs = 0; bs < afp.getBlockNum(); ++bs) {
                BlockSetImpl blockSet = new BlockSetImpl(msa);
                Matrix4d blockTr = null;
                try {
                    blockTr = Calc.getTransformation(rot[bs], shift[bs]);
                }
                catch (IndexOutOfBoundsException e) {
                    blockTr = ident;
                }
                catch (NullPointerException e) {
                    blockTr = ident;
                }
                blockSet.setTransformations(Arrays.asList(ident, blockTr));
                BlockImpl block = new BlockImpl(blockSet);
                block.setAlignRes(new ArrayList<List<Integer>>());
                block.getAlignRes().add(new ArrayList());
                block.getAlignRes().add(new ArrayList());
                Matrix rotB = afp.getBlockRotationMatrix()[bs];
                Atom shiftB = afp.getBlockShiftVector()[bs];
                Matrix4d transformB = Calc.getTransformation(rotB, shiftB);
                blockSet.setTransformations(Arrays.asList(ident, transformB));
                for (int i = 0; i < afp.getOptAln()[bs][0].length; ++i) {
                    block.getAlignRes().get(0).add(afp.getOptAln()[bs][0][i]);
                    block.getAlignRes().get(1).add(afp.getOptAln()[bs][1][i]);
                }
            }
        } else {
            BlockSetImpl blockSet = new BlockSetImpl(msa);
            Matrix4d blockTr = null;
            try {
                blockTr = Calc.getTransformation(rot[0], shift[0]);
            }
            catch (IndexOutOfBoundsException e) {
                blockTr = ident;
            }
            catch (NullPointerException e) {
                blockTr = ident;
            }
            blockSet.setTransformations(Arrays.asList(ident, blockTr));
            for (int bs = 0; bs < afp.getBlockNum(); ++bs) {
                BlockImpl block = new BlockImpl(blockSet);
                block.setAlignRes(new ArrayList<List<Integer>>());
                block.getAlignRes().add(new ArrayList());
                block.getAlignRes().add(new ArrayList());
                for (int i = 0; i < afp.getOptAln()[bs][0].length; ++i) {
                    block.getAlignRes().get(0).add(afp.getOptAln()[bs][0][i]);
                    block.getAlignRes().get(1).add(afp.getOptAln()[bs][1][i]);
                }
            }
        }
        msa.putScore("Probability", afp.getProbability());
        msa.putScore("AvgTM-score", afp.getTMScore());
        msa.putScore("CE-score", afp.getAlignScore());
        msa.putScore("RMSD", afp.getTotalRmsdOpt());
    }

    @Override
    public MultipleAlignmentEnsembleImpl clone() {
        return new MultipleAlignmentEnsembleImpl(this);
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Long getIoTime() {
        return this.ioTime;
    }

    @Override
    public void setIoTime(Long millis) {
        this.ioTime = millis;
    }

    @Override
    public Long getCalculationTime() {
        return this.calculationTime;
    }

    @Override
    public void setCalculationTime(Long millis) {
        this.calculationTime = millis;
    }

    @Override
    public List<StructureIdentifier> getStructureIdentifiers() {
        return this.structureIdentifiers;
    }

    @Override
    public void setStructureIdentifiers(List<StructureIdentifier> structureNames) {
        this.structureIdentifiers = structureNames;
    }

    @Override
    public List<Atom[]> getAtomArrays() {
        if (this.atomArrays == null) {
            try {
                this.updateAtomArrays();
            }
            catch (IOException e) {
                throw new NullPointerException(e.getMessage());
            }
            catch (StructureException e) {
                throw new NullPointerException(e.getMessage());
            }
        }
        return this.atomArrays;
    }

    @Override
    public void setAtomArrays(List<Atom[]> atomArrays) {
        this.atomArrays = atomArrays;
    }

    public void updateAtomArrays() throws IOException, StructureException {
        AtomCache cache = new AtomCache();
        this.atomArrays = new ArrayList<Atom[]>();
        for (StructureIdentifier name : this.getStructureIdentifiers()) {
            Atom[] array = cache.getRepresentativeAtoms(name);
            this.atomArrays.add(array);
        }
    }

    @Override
    public List<Matrix> getDistanceMatrix() {
        if (this.distanceMatrix == null) {
            this.updateDistanceMatrix();
        }
        return this.distanceMatrix;
    }

    public void updateDistanceMatrix() {
        this.distanceMatrix = new ArrayList<Matrix>();
        for (int s = 0; s < this.size(); ++s) {
            Atom[] ca = this.atomArrays.get(s);
            Matrix distMat = AlignTools.getDistanceMatrix(ca, ca);
            this.distanceMatrix.add(distMat);
        }
    }

    @Override
    public List<MultipleAlignment> getMultipleAlignments() {
        if (this.multipleAlignments == null) {
            this.multipleAlignments = new ArrayList<MultipleAlignment>();
        }
        return this.multipleAlignments;
    }

    @Override
    public MultipleAlignment getMultipleAlignment(int index) {
        return this.multipleAlignments.get(index);
    }

    @Override
    public void setMultipleAlignments(List<MultipleAlignment> alignments) {
        this.multipleAlignments = alignments;
    }

    @Override
    public void addMultipleAlignment(MultipleAlignment alignment) {
        if (this.multipleAlignments == null) {
            this.multipleAlignments = new ArrayList<MultipleAlignment>();
        }
        this.multipleAlignments.add(alignment);
        alignment.setEnsemble(this);
    }

    @Override
    public int size() {
        if (this.structureIdentifiers != null) {
            return this.structureIdentifiers.size();
        }
        if (this.atomArrays != null) {
            return this.atomArrays.size();
        }
        throw new IndexOutOfBoundsException("Empty ensemble: names == null && atoms == null");
    }

    @Override
    public void clear() {
        super.clear();
        this.distanceMatrix = null;
        for (MultipleAlignment a : this.getMultipleAlignments()) {
            a.clear();
        }
    }
}

