/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cluster;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.biojava.nbio.structure.cluster.SubunitCluster;

public class SubunitClusterUtils {
    private SubunitClusterUtils() {
    }

    public static String getStoichiometryString(List<SubunitCluster> clusters) {
        List stoichiometries = clusters.stream().map(SubunitCluster::size).sorted().collect(Collectors.toList());
        Collections.reverse(stoichiometries);
        String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        StringBuilder formula = new StringBuilder();
        for (int i = 0; i < stoichiometries.size(); ++i) {
            String key = clusters.get(i).getAlpha();
            if (key.isEmpty()) {
                int ind = i % alpha.length();
                key = alpha.substring(ind, ind + 1);
            }
            formula.append(key);
            if ((Integer)stoichiometries.get(i) <= 1) continue;
            formula.append(stoichiometries.get(i));
        }
        return formula.toString();
    }

    public static List<SubunitCluster> orderByStoichiometry(List<SubunitCluster> clusters) {
        String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        List<SubunitCluster> clustersSorted = clusters.stream().sorted(Comparator.comparing(SubunitCluster::size).reversed()).collect(Collectors.toList());
        for (int i = 0; i < clustersSorted.size(); ++i) {
            int ind = i % alpha.length();
            String key = alpha.substring(ind, ind + 1);
            clustersSorted.get(i).setAlpha(key);
        }
        return clustersSorted;
    }

    public static boolean isPseudoStoichiometric(List<SubunitCluster> clusters) {
        for (SubunitCluster c : clusters) {
            if (!c.isPseudoStoichiometric()) continue;
            return true;
        }
        return false;
    }
}

