/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.geometry;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.SuperPositionAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SuperPositionQCP
extends SuperPositionAbstract {
    private static final Logger logger = LoggerFactory.getLogger(SuperPositionQCP.class);
    private double evec_prec = 1.0E-6;
    private double eval_prec = 1.0E-11;
    private Point3d[] x;
    private Point3d[] y;
    private double[] weight;
    private double wsum;
    private Point3d[] xref;
    private Point3d[] yref;
    private Point3d xtrans;
    private Point3d ytrans;
    private double e0;
    private Matrix3d rotmat = new Matrix3d();
    private Matrix4d transformation = new Matrix4d();
    private double rmsd = 0.0;
    private double Sxy;
    private double Sxz;
    private double Syx;
    private double Syz;
    private double Szx;
    private double Szy;
    private double SxxpSyy;
    private double Szz;
    private double mxEigenV;
    private double SyzmSzy;
    private double SxzmSzx;
    private double SxymSyx;
    private double SxxmSyy;
    private double SxypSyx;
    private double SxzpSzx;
    private double Syy;
    private double Sxx;
    private double SyzpSzy;
    private boolean rmsdCalculated = false;
    private boolean transformationCalculated = false;
    private boolean centered = false;

    public SuperPositionQCP(boolean centered) {
        super(centered);
    }

    public SuperPositionQCP(boolean centered, double evec_prec, double eval_prec) {
        super(centered);
        this.evec_prec = evec_prec;
        this.eval_prec = eval_prec;
    }

    private void set(Point3d[] x, Point3d[] y) {
        this.x = x;
        this.y = y;
        this.rmsdCalculated = false;
        this.transformationCalculated = false;
    }

    private void set(Point3d[] x, Point3d[] y, double[] weight) {
        this.x = x;
        this.y = y;
        this.weight = weight;
        this.rmsdCalculated = false;
        this.transformationCalculated = false;
    }

    private double getRmsd() {
        if (!this.rmsdCalculated) {
            this.calcRmsd(this.x, this.y);
        }
        return this.rmsd;
    }

    @Override
    public Matrix4d superpose(Point3d[] fixed, Point3d[] moved) {
        this.set(moved, fixed);
        this.getRotationMatrix();
        if (!this.centered) {
            this.calcTransformation();
        } else {
            this.transformation.set(this.rotmat);
        }
        return this.transformation;
    }

    public Matrix4d weightedSuperpose(Point3d[] fixed, Point3d[] moved, double[] weight) {
        this.set(moved, fixed, weight);
        this.getRotationMatrix();
        if (!this.centered) {
            this.calcTransformation();
        } else {
            this.transformation.set(this.rotmat);
        }
        return this.transformation;
    }

    private Matrix3d getRotationMatrix() {
        this.getRmsd();
        if (!this.transformationCalculated) {
            this.calcRotationMatrix();
        }
        return this.rotmat;
    }

    private void calcRmsd(Point3d[] x, Point3d[] y) {
        if (this.centered) {
            this.innerProduct(y, x);
        } else {
            this.xref = CalcPoint.clonePoint3dArray(x);
            this.xtrans = CalcPoint.centroid(this.xref);
            logger.debug("x centroid: " + this.xtrans);
            this.xtrans.negate();
            CalcPoint.translate(new Vector3d((Tuple3d)this.xtrans), this.xref);
            this.yref = CalcPoint.clonePoint3dArray(y);
            this.ytrans = CalcPoint.centroid(this.yref);
            logger.debug("y centroid: " + this.ytrans);
            this.ytrans.negate();
            CalcPoint.translate(new Vector3d((Tuple3d)this.ytrans), this.yref);
            this.innerProduct(this.yref, this.xref);
        }
        this.calcRmsd(this.wsum);
    }

    private void calcTransformation() {
        this.transformation.set(this.rotmat);
        Matrix4d trans = new Matrix4d();
        trans.setIdentity();
        trans.setTranslation(new Vector3d((Tuple3d)this.xtrans));
        this.transformation.mul(this.transformation, trans);
        this.ytrans.negate();
        Matrix4d transInverse = new Matrix4d();
        transInverse.setIdentity();
        transInverse.setTranslation(new Vector3d((Tuple3d)this.ytrans));
        this.transformation.mul(transInverse, this.transformation);
    }

    private void innerProduct(Point3d[] coords1, Point3d[] coords2) {
        double g1 = 0.0;
        double g2 = 0.0;
        this.Sxx = 0.0;
        this.Sxy = 0.0;
        this.Sxz = 0.0;
        this.Syx = 0.0;
        this.Syy = 0.0;
        this.Syz = 0.0;
        this.Szx = 0.0;
        this.Szy = 0.0;
        this.Szz = 0.0;
        if (this.weight != null) {
            this.wsum = 0.0;
            for (int i = 0; i < coords1.length; ++i) {
                this.wsum += this.weight[i];
                double x1 = this.weight[i] * coords1[i].x;
                double y1 = this.weight[i] * coords1[i].y;
                double z1 = this.weight[i] * coords1[i].z;
                g1 += x1 * coords1[i].x + y1 * coords1[i].y + z1 * coords1[i].z;
                double x2 = coords2[i].x;
                double y2 = coords2[i].y;
                double z2 = coords2[i].z;
                g2 += this.weight[i] * (x2 * x2 + y2 * y2 + z2 * z2);
                this.Sxx += x1 * x2;
                this.Sxy += x1 * y2;
                this.Sxz += x1 * z2;
                this.Syx += y1 * x2;
                this.Syy += y1 * y2;
                this.Syz += y1 * z2;
                this.Szx += z1 * x2;
                this.Szy += z1 * y2;
                this.Szz += z1 * z2;
            }
        } else {
            for (int i = 0; i < coords1.length; ++i) {
                g1 += coords1[i].x * coords1[i].x + coords1[i].y * coords1[i].y + coords1[i].z * coords1[i].z;
                g2 += coords2[i].x * coords2[i].x + coords2[i].y * coords2[i].y + coords2[i].z * coords2[i].z;
                this.Sxx += coords1[i].x * coords2[i].x;
                this.Sxy += coords1[i].x * coords2[i].y;
                this.Sxz += coords1[i].x * coords2[i].z;
                this.Syx += coords1[i].y * coords2[i].x;
                this.Syy += coords1[i].y * coords2[i].y;
                this.Syz += coords1[i].y * coords2[i].z;
                this.Szx += coords1[i].z * coords2[i].x;
                this.Szy += coords1[i].z * coords2[i].y;
                this.Szz += coords1[i].z * coords2[i].z;
            }
            this.wsum = coords1.length;
        }
        this.e0 = (g1 + g2) * 0.5;
    }

    private int calcRmsd(double len) {
        int i;
        double Sxx2 = this.Sxx * this.Sxx;
        double Syy2 = this.Syy * this.Syy;
        double Szz2 = this.Szz * this.Szz;
        double Sxy2 = this.Sxy * this.Sxy;
        double Syz2 = this.Syz * this.Syz;
        double Sxz2 = this.Sxz * this.Sxz;
        double Syx2 = this.Syx * this.Syx;
        double Szy2 = this.Szy * this.Szy;
        double Szx2 = this.Szx * this.Szx;
        double SyzSzymSyySzz2 = 2.0 * (this.Syz * this.Szy - this.Syy * this.Szz);
        double Sxx2Syy2Szz2Syz2Szy2 = Syy2 + Szz2 - Sxx2 + Syz2 + Szy2;
        double c2 = -2.0 * (Sxx2 + Syy2 + Szz2 + Sxy2 + Syx2 + Sxz2 + Szx2 + Syz2 + Szy2);
        double c1 = 8.0 * (this.Sxx * this.Syz * this.Szy + this.Syy * this.Szx * this.Sxz + this.Szz * this.Sxy * this.Syx - this.Sxx * this.Syy * this.Szz - this.Syz * this.Szx * this.Sxy - this.Szy * this.Syx * this.Sxz);
        this.SxzpSzx = this.Sxz + this.Szx;
        this.SyzpSzy = this.Syz + this.Szy;
        this.SxypSyx = this.Sxy + this.Syx;
        this.SyzmSzy = this.Syz - this.Szy;
        this.SxzmSzx = this.Sxz - this.Szx;
        this.SxymSyx = this.Sxy - this.Syx;
        this.SxxpSyy = this.Sxx + this.Syy;
        this.SxxmSyy = this.Sxx - this.Syy;
        double Sxy2Sxz2Syx2Szx2 = Sxy2 + Sxz2 - Syx2 - Szx2;
        double c0 = Sxy2Sxz2Syx2Szx2 * Sxy2Sxz2Syx2Szx2 + (Sxx2Syy2Szz2Syz2Szy2 + SyzSzymSyySzz2) * (Sxx2Syy2Szz2Syz2Szy2 - SyzSzymSyySzz2) + (-this.SxzpSzx * this.SyzmSzy + this.SxymSyx * (this.SxxmSyy - this.Szz)) * (-this.SxzmSzx * this.SyzpSzy + this.SxymSyx * (this.SxxmSyy + this.Szz)) + (-this.SxzpSzx * this.SyzpSzy - this.SxypSyx * (this.SxxpSyy - this.Szz)) * (-this.SxzmSzx * this.SyzmSzy - this.SxypSyx * (this.SxxpSyy + this.Szz)) + (this.SxypSyx * this.SyzpSzy + this.SxzpSzx * (this.SxxmSyy + this.Szz)) * (-this.SxymSyx * this.SyzmSzy + this.SxzpSzx * (this.SxxpSyy + this.Szz)) + (this.SxypSyx * this.SyzmSzy + this.SxzmSzx * (this.SxxmSyy - this.Szz)) * (-this.SxymSyx * this.SyzpSzy + this.SxzmSzx * (this.SxxpSyy - this.Szz));
        this.mxEigenV = this.e0;
        for (i = 1; i < 51; ++i) {
            double oldg = this.mxEigenV;
            double x2 = this.mxEigenV * this.mxEigenV;
            double b = (x2 + c2) * this.mxEigenV;
            double a = b + c1;
            double delta = (a * this.mxEigenV + c0) / (2.0 * x2 * this.mxEigenV + b + a);
            this.mxEigenV -= delta;
            if (Math.abs(this.mxEigenV - oldg) < Math.abs(this.eval_prec * this.mxEigenV)) break;
        }
        if (i == 50) {
            logger.warn(String.format("More than %d iterations needed!", i));
        } else {
            logger.info(String.format("%d iterations needed!", i));
        }
        this.rmsd = Math.sqrt(Math.abs(2.0 * (this.e0 - this.mxEigenV) / len));
        return 1;
    }

    private int calcRotationMatrix() {
        double a1122_1221;
        double a1123_1321;
        double a1124_1421;
        double a1223_1322;
        double a1224_1422;
        double a1324_1423;
        double a11 = this.SxxpSyy + this.Szz - this.mxEigenV;
        double a12 = this.SyzmSzy;
        double a22 = this.SxxmSyy - this.Szz - this.mxEigenV;
        double a33 = this.Syy - this.Sxx - this.Szz - this.mxEigenV;
        double a44 = this.Szz - this.SxxpSyy - this.mxEigenV;
        double a34 = this.SyzpSzy;
        double a43 = a34;
        double a3344_4334 = a33 * a44 - a43 * a34;
        double a23 = this.SxypSyx;
        double a32 = a23;
        double a24 = this.SxzpSzx;
        double a42 = a24;
        double a3244_4234 = a32 * a44 - a42 * a34;
        double a3243_4233 = a32 * a43 - a42 * a33;
        double q1 = a22 * a3344_4334 - a23 * a3244_4234 + a24 * a3243_4233;
        double a21 = this.SyzmSzy;
        double a13 = -this.SxzmSzx;
        double a31 = a13;
        double a14 = this.SxymSyx;
        double a41 = a14;
        double a3144_4134 = a31 * a44 - a41 * a34;
        double a3143_4133 = a31 * a43 - a41 * a33;
        double q2 = -a21 * a3344_4334 + a23 * a3144_4134 - a24 * a3143_4133;
        double a3142_4132 = a31 * a42 - a41 * a32;
        double q3 = a21 * a3244_4234 - a22 * a3144_4134 + a24 * a3142_4132;
        double q4 = -a21 * a3243_4233 + a22 * a3143_4133 - a23 * a3142_4132;
        double qsqr = q1 * q1 + q2 * q2 + q3 * q3 + q4 * q4;
        if (qsqr < this.evec_prec && (qsqr = (q1 = a12 * a3344_4334 - a13 * a3244_4234 + a14 * a3243_4233) * q1 + (q2 = -a11 * a3344_4334 + a13 * a3144_4134 - a14 * a3143_4133) * q2 + (q3 = a11 * a3244_4234 - a12 * a3144_4134 + a14 * a3142_4132) * q3 + (q4 = -a11 * a3243_4233 + a12 * a3143_4133 - a13 * a3142_4132) * q4) < this.evec_prec && (qsqr = (q1 = a42 * (a1324_1423 = a13 * a24 - a14 * a23) - a43 * (a1224_1422 = a12 * a24 - a14 * a22) + a44 * (a1223_1322 = a12 * a23 - a13 * a22)) * q1 + (q2 = -a41 * a1324_1423 + a43 * (a1124_1421 = a11 * a24 - a14 * a21) - a44 * (a1123_1321 = a11 * a23 - a13 * a21)) * q2 + (q3 = a41 * a1224_1422 - a42 * a1124_1421 + a44 * (a1122_1221 = a11 * a22 - a12 * a21)) * q3 + (q4 = -a41 * a1223_1322 + a42 * a1123_1321 - a43 * a1122_1221) * q4) < this.evec_prec && (qsqr = (q1 = a32 * a1324_1423 - a33 * a1224_1422 + a34 * a1223_1322) * q1 + (q2 = -a31 * a1324_1423 + a33 * a1124_1421 - a34 * a1123_1321) * q2 + (q3 = a31 * a1224_1422 - a32 * a1124_1421 + a34 * a1122_1221) * q3 + (q4 = -a31 * a1223_1322 + a32 * a1123_1321 - a33 * a1122_1221) * q4) < this.evec_prec) {
            this.rotmat.setIdentity();
            return 0;
        }
        double normq = Math.sqrt(qsqr);
        logger.debug("q: " + (q1 /= normq) + " " + (q2 /= normq) + " " + (q3 /= normq) + " " + (q4 /= normq));
        double a2 = q1 * q1;
        double x2 = q2 * q2;
        double y2 = q3 * q3;
        double z2 = q4 * q4;
        double xy = q2 * q3;
        double az = q1 * q4;
        double zx = q4 * q2;
        double ay = q1 * q3;
        double yz = q3 * q4;
        double ax = q1 * q2;
        this.rotmat.m00 = a2 + x2 - y2 - z2;
        this.rotmat.m01 = 2.0 * (xy + az);
        this.rotmat.m02 = 2.0 * (zx - ay);
        this.rotmat.m10 = 2.0 * (xy - az);
        this.rotmat.m11 = a2 - x2 + y2 - z2;
        this.rotmat.m12 = 2.0 * (yz + ax);
        this.rotmat.m20 = 2.0 * (zx + ay);
        this.rotmat.m21 = 2.0 * (yz - ax);
        this.rotmat.m22 = a2 - x2 - y2 + z2;
        return 1;
    }

    @Override
    public double getRmsd(Point3d[] fixed, Point3d[] moved) {
        this.set(moved, fixed);
        return this.getRmsd();
    }

    public double getWeightedRmsd(Point3d[] fixed, Point3d[] moved, double[] weight) {
        this.set(moved, fixed, weight);
        return this.getRmsd();
    }
}

