/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileParsingParameters
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(FileParsingParameters.class);
    private static final long serialVersionUID = 5878292315163939027L;
    private boolean parseSecStruc;
    private boolean alignSeqRes;
    private boolean parseCAOnly;
    private boolean headerOnly;
    private boolean updateRemediatedFiles;
    public static final int ATOM_CA_THRESHOLD = 500000;
    private int atomCaThreshold;
    private boolean parseBioAssembly;
    private boolean createAtomBonds;
    private boolean createAtomCharges;
    public static final int MAX_ATOMS = Integer.MAX_VALUE;
    int maxAtoms;
    String[] fullAtomNames;

    public FileParsingParameters() {
        this.setDefault();
    }

    public void setDefault() {
        this.parseSecStruc = false;
        this.alignSeqRes = true;
        this.parseCAOnly = false;
        this.headerOnly = false;
        this.updateRemediatedFiles = false;
        this.fullAtomNames = null;
        this.maxAtoms = Integer.MAX_VALUE;
        this.atomCaThreshold = 500000;
        this.parseBioAssembly = false;
        this.createAtomBonds = false;
        this.createAtomCharges = true;
    }

    public boolean isParseSecStruc() {
        return this.parseSecStruc;
    }

    public void setParseSecStruc(boolean parseSecStruc) {
        this.parseSecStruc = parseSecStruc;
    }

    public boolean isHeaderOnly() {
        return this.headerOnly;
    }

    public void setHeaderOnly(boolean headerOnly) {
        this.headerOnly = headerOnly;
    }

    public boolean isParseCAOnly() {
        return this.parseCAOnly;
    }

    public void setParseCAOnly(boolean parseCAOnly) {
        this.parseCAOnly = parseCAOnly;
    }

    public boolean isAlignSeqRes() {
        return this.alignSeqRes;
    }

    public void setAlignSeqRes(boolean alignSeqRes) {
        this.alignSeqRes = alignSeqRes;
    }

    @Deprecated
    public boolean isUpdateRemediatedFiles() {
        return this.updateRemediatedFiles;
    }

    @Deprecated
    public void setUpdateRemediatedFiles(boolean updateRemediatedFiles) {
        logger.warn("FileParsingParameters.setUpdateRemediatedFiles() is deprecated, please use LocalPDBDirectory.setFetchBehavior() instead. The option will be removed in upcoming releases");
        this.updateRemediatedFiles = updateRemediatedFiles;
    }

    public String[] getAcceptedAtomNames() {
        return this.fullAtomNames;
    }

    public void setAcceptedAtomNames(String[] fullAtomNames) {
        this.fullAtomNames = fullAtomNames;
    }

    public int getMaxAtoms() {
        return this.maxAtoms;
    }

    public void setMaxAtoms(int maxAtoms) {
        this.maxAtoms = maxAtoms;
    }

    public int getAtomCaThreshold() {
        return this.atomCaThreshold;
    }

    public void setAtomCaThreshold(int atomCaThreshold) {
        this.atomCaThreshold = atomCaThreshold;
    }

    public boolean isParseBioAssembly() {
        return this.parseBioAssembly;
    }

    public void setParseBioAssembly(boolean parseBioAssembly) {
        this.parseBioAssembly = parseBioAssembly;
    }

    public boolean shouldCreateAtomBonds() {
        return this.createAtomBonds;
    }

    public void setCreateAtomBonds(boolean createAtomBonds) {
        this.createAtomBonds = createAtomBonds;
    }

    public boolean shouldCreateAtomCharges() {
        return this.createAtomCharges;
    }

    public void setCreateAtomCharges(boolean createAtomCharges) {
        this.createAtomCharges = createAtomCharges;
    }
}

