/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.PDBFileParser;
import org.biojava.nbio.structure.io.StructureProvider;

public class SandboxStyleStructureProvider
implements StructureProvider {
    FileParsingParameters params = new FileParsingParameters();
    String path;
    public static final String fileSeparator = System.getProperty("file.separator");

    public SandboxStyleStructureProvider() {
        UserConfiguration config = new UserConfiguration();
        this.setPath(config.getPdbFilePath());
    }

    public void setPath(String p) {
        this.path = p;
        if (!this.path.endsWith(fileSeparator)) {
            this.path = this.path + fileSeparator;
        }
    }

    @Override
    public Structure getStructureById(String pdbId) throws IOException, StructureException {
        if (pdbId == null || pdbId.length() < 4) {
            throw new StructureException("This does not look like a valid PDB ID! (" + pdbId + ")");
        }
        pdbId = pdbId.toLowerCase();
        String middle = pdbId.substring(1, 3).toLowerCase();
        File f = new File(this.path + fileSeparator + middle + fileSeparator + pdbId + fileSeparator + "pdb" + pdbId + ".ent.gz");
        if (!f.exists()) {
            // empty if block
        }
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inputStream = isp.getInputStream(f);
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setFileParsingParameters(this.params);
        Structure struc = pdbpars.parsePDBFile(inputStream);
        return struc;
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }

    public List<String> getAllPDBIDs() throws IOException {
        File f = new File(this.path);
        if (!f.isDirectory()) {
            throw new IOException("Path " + this.path + " is not a directory!");
        }
        String[] dirName = f.list();
        ArrayList<String> pdbIds = new ArrayList<String>();
        for (String dir : dirName) {
            String[] pdbDirs;
            File d2 = new File(f, dir);
            if (!d2.isDirectory()) continue;
            for (String pdbId : pdbDirs = d2.list()) {
                if (pdbIds.contains(pdbId)) continue;
                pdbIds.add(pdbId);
            }
        }
        return pdbIds;
    }
}

