/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.io.Serializable;
import java.util.Set;

public class QuatSymmetryParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double rmsdThreshold = 7.0;
    private double angleThreshold = 10.0;
    private double helixRmsdThreshold = 0.05;
    private double helixRmsdToRiseRatio = 0.5;
    private double minimumHelixRise = 1.0;
    private double minimumHelixAngle = 5.0;
    private int maximumLocalCombinations = 10000;
    private double localTimeLimit = 120.0;
    private double localTimeStart = -1.0;
    private boolean onTheFly = true;

    public double getRmsdThreshold() {
        return this.rmsdThreshold;
    }

    public void setRmsdThreshold(double rmsdThreshold) {
        this.rmsdThreshold = rmsdThreshold;
    }

    public double getAngleThreshold() {
        return this.angleThreshold;
    }

    public void setAngleThreshold(double angleThreshold) {
        this.angleThreshold = angleThreshold;
    }

    public double getHelixRmsdThreshold() {
        return this.helixRmsdThreshold;
    }

    public void setHelixRmsdThreshold(double helixRmsdThreshold) {
        this.helixRmsdThreshold = helixRmsdThreshold;
    }

    public double getHelixRmsdToRiseRatio() {
        return this.helixRmsdToRiseRatio;
    }

    public void setHelixRmsdToRiseRatio(double helixRmsdToRiseRatio) {
        this.helixRmsdToRiseRatio = helixRmsdToRiseRatio;
    }

    public double getMinimumHelixRise() {
        return this.minimumHelixRise;
    }

    public void setMinimumHelixRise(double minimumHelixRise) {
        this.minimumHelixRise = minimumHelixRise;
    }

    public double getMinimumHelixAngle() {
        return this.minimumHelixAngle;
    }

    public void setMinimumHelixAngle(double minimumHelixAngle) {
        this.minimumHelixAngle = minimumHelixAngle;
    }

    public int getMaximumLocalCombinations() {
        return this.maximumLocalCombinations;
    }

    public void setMaximumLocalCombinations(int maximumLocalCombinations) {
        this.maximumLocalCombinations = maximumLocalCombinations;
    }

    public double getLocalTimeLimit() {
        return this.localTimeLimit;
    }

    public void setLocalTimeLimit(double localTimeLimit) {
        this.localTimeLimit = localTimeLimit;
    }

    public double getLocalTimeStart() {
        return this.localTimeStart;
    }

    public void useLocalTimeLimit(double localTimeStart) {
        this.localTimeStart = localTimeStart;
    }

    public boolean isLocalLimitsExceeded(Set combinations) {
        if (combinations.size() > this.maximumLocalCombinations) {
            return true;
        }
        return this.isLocalLimitsExceeded();
    }

    public boolean isLocalLimitsExceeded() {
        if (this.localTimeStart < 0.0) {
            return false;
        }
        double elapsedTime = ((double)System.nanoTime() - this.localTimeStart) / 1.0E9;
        return elapsedTime > this.localTimeLimit;
    }

    public boolean isOnTheFly() {
        return this.onTheFly;
    }

    public void setOnTheFly(boolean useJmolBioAssemblies) {
        this.onTheFly = useJmolBioAssemblies;
    }

    public String toString() {
        return "QuatSymmetryParameters [rmsdThreshold=" + this.rmsdThreshold + ", angleThreshold=" + this.angleThreshold + ", helixRmsdThreshold=" + this.helixRmsdThreshold + ", helixRmsdToRiseRatio=" + this.helixRmsdToRiseRatio + ", minimumHelixRise=" + this.minimumHelixRise + ", minimumHelixAngle=" + this.minimumHelixAngle + ", maximumLocalCombinations=" + this.maximumLocalCombinations + ", localTimeStart=" + this.localTimeStart + ", localTimeLimit=" + this.localTimeLimit + ", onTheFly=" + this.onTheFly + "]";
    }
}

