/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.ecod;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.core.util.FileDownloadUtils;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.ecod.EcodDatabase;
import org.biojava.nbio.structure.ecod.EcodDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcodInstallation
implements EcodDatabase {
    private static final Logger logger = LoggerFactory.getLogger(EcodInstallation.class);
    public static final String DEFAULT_VERSION = "latest";
    private static final String DOMAINS_FILENAME_FORMAT = "ecod.%s.domains.txt";
    public static final String ECOD_URL = "http://prodata.swmed.edu";
    public static final String DOMAINS_PATH = "/ecod/distributions/";
    public static final Pattern ECOD_RE = Pattern.compile("^e(....).+\\d+$");
    private String cacheLocation;
    private String requestedVersion;
    private String parsedVersion;
    private ReadWriteLock domainsFileLock = new ReentrantReadWriteLock();
    private List<EcodDomain> allDomains;
    private Map<PdbId, List<EcodDomain>> domainMap;
    private String url;
    private Integer updateFrequency = 14;

    public EcodInstallation(String cacheLocation, String version) {
        this.cacheLocation = cacheLocation;
        this.requestedVersion = version;
        this.url = ECOD_URL;
        this.allDomains = null;
        this.domainMap = null;
    }

    public EcodInstallation() {
        this(new UserConfiguration().getCacheFilePath(), DEFAULT_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EcodDomain> getDomainsForPdb(String id) throws IOException {
        this.domainsFileLock.readLock().lock();
        try {
            logger.trace("LOCK readlock");
            while (this.domainMap == null) {
                logger.trace("UNLOCK readlock");
                this.domainsFileLock.readLock().unlock();
                this.indexDomains();
                this.domainsFileLock.readLock().lock();
                logger.trace("LOCK readlock");
            }
            PdbId pdbId = null;
            try {
                pdbId = new PdbId(id);
            }
            catch (IllegalArgumentException e) {
                List<EcodDomain> list = null;
                logger.trace("UNLOCK readlock");
                this.domainsFileLock.readLock().unlock();
                return list;
            }
            List<EcodDomain> doms = this.domainMap.get(pdbId);
            if (doms == null) {
                List<EcodDomain> list = null;
                return list;
            }
            ArrayList<EcodDomain> clonedDoms = new ArrayList<EcodDomain>(doms.size());
            for (EcodDomain d : doms) {
                clonedDoms.add(new EcodDomain(d));
            }
            ArrayList<EcodDomain> arrayList = clonedDoms;
            return arrayList;
        }
        finally {
            logger.trace("UNLOCK readlock");
            this.domainsFileLock.readLock().unlock();
        }
    }

    @Override
    public List<EcodDomain> filterByHierarchy(String hierarchy) throws IOException {
        String[] xhtGroup = hierarchy.split("\\.");
        Integer xGroup = xhtGroup.length > 0 ? Integer.valueOf(Integer.parseInt(xhtGroup[0])) : null;
        Integer hGroup = xhtGroup.length > 1 ? Integer.valueOf(Integer.parseInt(xhtGroup[1])) : null;
        Integer tGroup = xhtGroup.length > 2 ? Integer.valueOf(Integer.parseInt(xhtGroup[2])) : null;
        ArrayList<EcodDomain> filtered = new ArrayList<EcodDomain>();
        for (EcodDomain d : this.getAllDomains()) {
            boolean match = true;
            if (xhtGroup.length > 0) {
                boolean bl = match = match && xGroup.equals(d.getXGroup());
            }
            if (xhtGroup.length > 1) {
                boolean bl = match = match && hGroup.equals(d.getHGroup());
            }
            if (xhtGroup.length > 2) {
                boolean bl = match = match && tGroup.equals(d.getTGroup());
            }
            if (xhtGroup.length > 3) {
                logger.warn("Ignoring unexpected additional parts of ECOD {}", (Object)hierarchy);
            }
            if (!match) continue;
            filtered.add(d);
        }
        return filtered;
    }

    @Override
    public EcodDomain getDomainsById(String ecodId) throws IOException {
        List<EcodDomain> doms;
        if (ecodId == null || ecodId.isEmpty()) {
            return null;
        }
        Matcher match = ECOD_RE.matcher(ecodId);
        String pdbId = null;
        if (match.matches()) {
            pdbId = match.group(1);
        }
        if ((doms = this.getDomainsForPdb(pdbId)) == null) {
            logger.debug("Null domains for {} from {}", (Object)pdbId, (Object)ecodId);
            return null;
        }
        logger.debug("Got {} domains from {}", (Object)doms.size(), (Object)pdbId);
        for (EcodDomain d : doms) {
            if (!ecodId.equals(d.getDomainId())) continue;
            return d;
        }
        return null;
    }

    @Override
    public List<EcodDomain> getAllDomains() throws IOException {
        this.domainsFileLock.readLock().lock();
        logger.trace("LOCK readlock");
        try {
            while (this.allDomains == null) {
                logger.trace("UNLOCK readlock");
                this.domainsFileLock.readLock().unlock();
                this.ensureDomainsFileInstalled();
                this.domainsFileLock.readLock().lock();
                logger.trace("LOCK readlock");
            }
            List<EcodDomain> list = this.allDomains;
            return list;
        }
        finally {
            logger.trace("UNLOCK readlock");
            this.domainsFileLock.readLock().unlock();
        }
    }

    public void clear() {
        this.domainsFileLock.writeLock().lock();
        logger.trace("LOCK writelock");
        this.allDomains = null;
        this.domainMap = null;
        logger.trace("UNLOCK writelock");
        this.domainsFileLock.writeLock().unlock();
    }

    @Override
    public String getVersion() throws IOException {
        this.ensureDomainsFileInstalled();
        if (this.parsedVersion == null) {
            return this.requestedVersion;
        }
        return this.parsedVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCacheLocation() {
        return this.cacheLocation;
    }

    public void setCacheLocation(String cacheLocation) {
        if (cacheLocation.equals(this.cacheLocation)) {
            return;
        }
        this.domainsFileLock.writeLock().lock();
        logger.trace("LOCK writelock");
        this.cacheLocation = cacheLocation;
        logger.trace("UNLOCK writelock");
        this.domainsFileLock.writeLock().unlock();
    }

    public void ensureDomainsFileInstalled() throws IOException {
        this.domainsFileLock.readLock().lock();
        logger.trace("LOCK readlock");
        try {
            if (this.allDomains != null) {
                return;
            }
        }
        finally {
            logger.trace("UNLOCK readlock");
            this.domainsFileLock.readLock().unlock();
        }
        this.domainsFileLock.writeLock().lock();
        logger.trace("LOCK writelock");
        try {
            if (!this.domainsAvailable()) {
                this.downloadDomains();
            }
            this.parseDomains();
        }
        finally {
            logger.trace("UNLOCK writelock");
            this.domainsFileLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean domainsAvailable() {
        this.domainsFileLock.readLock().lock();
        logger.trace("LOCK readlock");
        try {
            File f = this.getDomainFile();
            if (!f.exists() || !FileDownloadUtils.validateFile((File)f)) {
                boolean bl = false;
                return bl;
            }
            if (this.updateFrequency != null && this.requestedVersion.equals(DEFAULT_VERSION)) {
                long mod = f.lastModified();
                Date lastUpdate = new Date();
                Calendar cal = Calendar.getInstance();
                cal.setTime(lastUpdate);
                cal.add(7, -this.updateFrequency.intValue());
                long updateTime = cal.getTimeInMillis();
                if (mod < updateTime) {
                    logger.info("{} is out of date.", (Object)f);
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            logger.trace("UNLOCK readlock");
            this.domainsFileLock.readLock().unlock();
        }
    }

    private void downloadDomains() throws IOException {
        this.domainsFileLock.writeLock().lock();
        logger.trace("LOCK writelock");
        try {
            URL domainsURL = new URL(this.url + DOMAINS_PATH + this.getDomainFilename());
            File localFile = this.getDomainFile();
            logger.info("Downloading {} to: {}", (Object)domainsURL, (Object)localFile);
            FileDownloadUtils.createValidationFiles((URL)domainsURL, (File)localFile, null, (FileDownloadUtils.Hash)FileDownloadUtils.Hash.UNKNOWN);
            FileDownloadUtils.downloadFile((URL)domainsURL, (File)localFile);
            if (!FileDownloadUtils.validateFile((File)localFile)) {
                throw new IOException("Downloaded file invalid: " + localFile);
            }
        }
        catch (MalformedURLException e) {
            logger.error("Malformed url: " + this.url + DOMAINS_PATH + this.getDomainFilename(), (Throwable)e);
        }
        finally {
            logger.trace("UNLOCK writelock");
            this.domainsFileLock.writeLock().unlock();
        }
    }

    private String getDomainFilename() {
        return String.format(DOMAINS_FILENAME_FORMAT, this.requestedVersion);
    }

    private File getDomainFile() {
        return new File(this.getCacheLocation(), this.getDomainFilename());
    }

    public Integer getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void setUpdateFrequency(Integer updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    private void parseDomains() throws IOException {
        this.domainsFileLock.writeLock().lock();
        logger.trace("LOCK writelock");
        try {
            EcodParser parser = new EcodParser(this.getDomainFile());
            this.allDomains = parser.getDomains();
            this.parsedVersion = parser.getVersion();
        }
        finally {
            logger.trace("UNLOCK writelock");
            this.domainsFileLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexDomains() throws IOException {
        this.domainsFileLock.writeLock().lock();
        logger.trace("LOCK writelock");
        try {
            if (this.allDomains == null) {
                this.ensureDomainsFileInstalled();
            }
            this.domainMap = new HashMap<PdbId, List<EcodDomain>>(176470, 0.85f);
            for (EcodDomain d : this.allDomains) {
                List<Object> currDomains;
                String ecodId;
                PdbId pdbId = d.getPdbId();
                if (pdbId == null && (ecodId = d.getDomainId()) != null && !ecodId.isEmpty()) {
                    Matcher match = ECOD_RE.matcher(ecodId);
                    pdbId = new PdbId(match.group(1));
                }
                if (this.domainMap.containsKey(pdbId)) {
                    currDomains = this.domainMap.get(pdbId);
                } else {
                    currDomains = new LinkedList();
                    this.domainMap.put(pdbId, currDomains);
                }
                currDomains.add(d);
            }
        }
        finally {
            logger.trace("UNLOCK writelock");
            this.domainsFileLock.writeLock().unlock();
        }
    }

    public String toString() {
        String version = null;
        try {
            version = this.getVersion();
        }
        catch (IOException e) {
            version = this.requestedVersion;
        }
        return "EcodInstallation [cacheLocation=" + this.cacheLocation + ", version=" + version + "]";
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: ecod_domains.txt");
            System.exit(1);
            return;
        }
        String filename = args[0];
        try {
            EcodParser parser = new EcodParser(filename);
            List<EcodDomain> domains = parser.getDomains();
            System.out.format("Found %d ECOD domains.%n", domains.size());
            System.out.println("First 10 domains:");
            int i = 0;
            for (EcodDomain d : domains) {
                if (i <= 10) {
                    System.out.println(d.getDomainId());
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class EcodParser {
        public static final String F_UNCLASSIFIED = "F_UNCLASSIFIED";
        public static final String NOT_DOMAIN_ASSEMBLY = "NOT_DOMAIN_ASSEMBLY";
        public static final String IS_DOMAIN_ASSEMBLY = "IS_DOMAIN_ASSEMBLY";
        public static final String IS_REPRESENTATIVE = "MANUAL_REP";
        public static final String NOT_REPRESENTATIVE = "AUTO_NONREP";
        private List<EcodDomain> domains;
        private String version = null;

        public EcodParser(String filename) throws IOException {
            this(new File(filename));
        }

        public EcodParser(File file) throws IOException {
            this(new FileReader(file));
        }

        public EcodParser(Reader reader) throws IOException {
            this(new BufferedReader(reader));
        }

        public EcodParser(BufferedReader reader) throws IOException {
            this.parse(reader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parse(BufferedReader in) throws IOException {
            try {
                ArrayList<EcodDomain> domainsList = new ArrayList<EcodDomain>(500000);
                Pattern versionRE = Pattern.compile("^\\s*#.*ECOD\\s*version\\s+(\\S+).*");
                Pattern commentRE = Pattern.compile("^\\s*#.*");
                int warnIsDomainAssembly = 1;
                int warnHierarchicalFormat = 5;
                int warnNumberOfFields = 10;
                String line = in.readLine();
                int lineNum = 1;
                while (line != null) {
                    Matcher match = versionRE.matcher(line);
                    if (match.matches()) {
                        this.version = match.group(1);
                    } else {
                        match = commentRE.matcher(line);
                        if (!match.matches()) {
                            String[] fields = line.split("\t");
                            if (fields.length == 13 || fields.length == 14 || fields.length == 15) {
                                try {
                                    String assemblyStr;
                                    String[] xhtGroup;
                                    int i = 0;
                                    Long uid = Long.parseLong(fields[i++]);
                                    String domainId = fields[i++];
                                    Boolean manual = null;
                                    if (fields.length >= 14) {
                                        String manualString;
                                        if ((manualString = fields[i++]).equalsIgnoreCase(IS_REPRESENTATIVE)) {
                                            manual = true;
                                        } else if (manualString.equalsIgnoreCase(NOT_REPRESENTATIVE)) {
                                            manual = false;
                                        } else {
                                            logger.warn("Unexpected value for manual field: {} in line {}", (Object)manualString, (Object)lineNum);
                                        }
                                    }
                                    if ((xhtGroup = fields[i++].split("\\.")).length < 3 || 4 < xhtGroup.length) {
                                        if (warnHierarchicalFormat > 1) {
                                            logger.warn("Unexpected format for hierarchical field \"{}\" in line {}", (Object)fields[i - 1], (Object)lineNum);
                                            --warnHierarchicalFormat;
                                        } else if (warnHierarchicalFormat != 0) {
                                            logger.warn("Unexpected format for hierarchical field \"{}\" in line {}. Not printing future similar warnings.", (Object)fields[i - 1], (Object)lineNum);
                                            --warnHierarchicalFormat;
                                        }
                                    }
                                    Integer xGroup = xhtGroup.length > 0 ? Integer.valueOf(Integer.parseInt(xhtGroup[0])) : null;
                                    Integer hGroup = xhtGroup.length > 1 ? Integer.valueOf(Integer.parseInt(xhtGroup[1])) : null;
                                    Integer tGroup = xhtGroup.length > 2 ? Integer.valueOf(Integer.parseInt(xhtGroup[2])) : null;
                                    Integer fGroup = xhtGroup.length > 3 ? Integer.valueOf(Integer.parseInt(xhtGroup[3])) : null;
                                    String pdbId = fields[i++];
                                    String chainId = fields[i++];
                                    String range = fields[i++];
                                    String seqId = null;
                                    if (fields.length >= 15) {
                                        seqId = fields[i++];
                                    }
                                    String architectureName = fields[i++].intern();
                                    String xGroupName = fields[i++].intern();
                                    String hGroupName = fields[i++].intern();
                                    String tGroupName = fields[i++].intern();
                                    String fGroupName = fields[i++].intern();
                                    hGroupName = this.clearStringQuotes(hGroupName);
                                    tGroupName = this.clearStringQuotes(tGroupName);
                                    fGroupName = this.clearStringQuotes(fGroupName);
                                    xGroupName = this.clearStringQuotes(xGroupName);
                                    Long assemblyId = null;
                                    if ((assemblyStr = fields[i++]).equals(NOT_DOMAIN_ASSEMBLY)) {
                                        assemblyId = uid;
                                    } else if (IS_DOMAIN_ASSEMBLY.equals(assemblyStr)) {
                                        if (warnIsDomainAssembly > 1) {
                                            logger.info("Deprecated 'IS_DOMAIN_ASSEMBLY' value ignored in line {}.", (Object)lineNum);
                                            --warnIsDomainAssembly;
                                        } else if (warnIsDomainAssembly == 0) {
                                            logger.info("Deprecated 'IS_DOMAIN_ASSEMBLY' value ignored in line {}. Not printing future similar warnings.", (Object)lineNum);
                                            --warnIsDomainAssembly;
                                        }
                                    } else {
                                        assemblyId = Long.parseLong(assemblyStr);
                                    }
                                    String ligandStr = fields[i++];
                                    Set<String> ligands = null;
                                    if ("NO_LIGANDS_4A".equals(ligandStr) || ligandStr.isEmpty()) {
                                        ligands = Collections.emptySet();
                                    } else {
                                        String[] ligSplit = ligandStr.split(",");
                                        ligands = new LinkedHashSet(ligSplit.length);
                                        for (String s : ligSplit) {
                                            ligands.add(s.intern());
                                        }
                                    }
                                    EcodDomain domain = new EcodDomain(uid, domainId, manual, xGroup, hGroup, tGroup, fGroup, pdbId, chainId, range, seqId, architectureName, xGroupName, hGroupName, tGroupName, fGroupName, assemblyId, ligands);
                                    domainsList.add(domain);
                                }
                                catch (NumberFormatException e) {
                                    logger.warn("Error in ECOD parsing at line " + lineNum, (Throwable)e);
                                }
                            } else if (warnNumberOfFields > 1) {
                                logger.warn("Unexpected number of fields in line {}.", (Object)lineNum);
                                --warnNumberOfFields;
                            } else if (warnNumberOfFields == 0) {
                                logger.warn("Unexpected number of fields in line {}. Not printing future similar warnings", (Object)lineNum);
                                --warnIsDomainAssembly;
                            }
                        }
                    }
                    line = in.readLine();
                    ++lineNum;
                }
                if (this.version == null) {
                    logger.info("Parsed {} ECOD domains", (Object)domainsList.size());
                } else {
                    logger.info("Parsed {} ECOD domains from version {}", (Object)domainsList.size(), (Object)this.version);
                }
                this.domains = Collections.unmodifiableList(domainsList);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }

        private String clearStringQuotes(String name) {
            if (name.startsWith("\"")) {
                name = name.substring(1);
            }
            if (name.endsWith("\"")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }

        public List<EcodDomain> getDomains() {
            return this.domains;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

