/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.sifts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.biojava.nbio.core.util.FileDownloadUtils;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.sifts.SiftsEntity;
import org.biojava.nbio.structure.io.sifts.SiftsXMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiftsMappingProvider {
    private static final Logger logger = LoggerFactory.getLogger(SiftsMappingProvider.class);
    private static final String EBI_SIFTS_FILE_LOCATION = "https://ftp.ebi.ac.uk/pub/databases/msd/sifts/xml/%s.xml.gz";
    private static String fileLoc = "https://ftp.ebi.ac.uk/pub/databases/msd/sifts/xml/%s.xml.gz";

    public static void setFileLocation(String myFileLocation) {
        fileLoc = myFileLocation;
    }

    public static List<SiftsEntity> getSiftsMapping(String pdbId) throws IOException {
        File hashDir;
        AtomCache cache = new AtomCache();
        String path = cache.getCachePath();
        pdbId = pdbId.toLowerCase();
        String dirHash = pdbId.substring(1, 3);
        File siftsDir = new File(path, "SIFTS");
        if (!siftsDir.exists()) {
            logger.info("Creating directory {}", (Object)siftsDir.toString());
            siftsDir.mkdir();
        }
        if (!(hashDir = new File(siftsDir, dirHash)).exists()) {
            logger.info("Creating directory {}", (Object)hashDir.toString());
            hashDir.mkdir();
        }
        File dest = new File(hashDir, pdbId + ".sifts.xml.gz");
        logger.debug("testing SIFTS file {}", (Object)dest.getAbsolutePath());
        if (!dest.exists()) {
            String u = String.format(fileLoc, pdbId);
            URL url = new URL(u);
            logger.debug("Downloading SIFTS file {} validation metadata.", (Object)url);
            FileDownloadUtils.createValidationFiles((URL)url, (File)dest, null, (FileDownloadUtils.Hash)FileDownloadUtils.Hash.UNKNOWN);
            logger.debug("Downloading SIFTS file {} to {}", (Object)url, (Object)dest);
            FileDownloadUtils.downloadFile((URL)url, (File)dest);
        }
        if (!FileDownloadUtils.validateFile((File)dest)) {
            throw new IOException("Downloaded file invalid: " + dest);
        }
        InputStreamProvider prov = new InputStreamProvider();
        InputStream is = prov.getInputStream(dest);
        SiftsXMLParser parser = new SiftsXMLParser();
        parser.parseXmlFile(is);
        return parser.getEntities();
    }
}

