/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.plugin.java.javasource.JCodeStatement;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;

public class JSourceCode {
    private List<JCodeStatement> source = null;
    private short indentSize;
    private short currentIndent = this.indentSize = (short)4;

    public JSourceCode() {
        this.source = new ArrayList<JCodeStatement>();
    }

    public JSourceCode(String sourceCode) {
        this();
        this.source.add(new JCodeStatement(sourceCode, this.currentIndent));
    }

    public void add(String statement) {
        JCodeStatement jcs = new JCodeStatement(statement, this.currentIndent);
        this.source.add(jcs);
    }

    public void add(String statement, short indentSize) {
        JCodeStatement jcs = new JCodeStatement(statement, indentSize);
        this.source.add(jcs);
    }

    public void addIndented(String statement) {
        this.indent();
        JCodeStatement jcs = new JCodeStatement(statement, this.currentIndent);
        this.source.add(jcs);
        this.unindent();
    }

    public void append(String segment) {
        if (this.source.isEmpty()) {
            this.add(segment);
        } else {
            JCodeStatement jcs = this.source.get(this.source.size() - 1);
            jcs.append(segment);
        }
    }

    public void clear() {
        this.source.clear();
    }

    public void copyInto(JSourceCode jsc) {
        for (int i = 0; i < this.source.size(); ++i) {
            jsc.addCodeStatement(this.source.get(i));
        }
    }

    public void indent() {
        this.currentIndent = (short)(this.currentIndent + this.indentSize);
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    public void print(JSourceWriter jsw) {
        for (int i = 0; i < this.source.size(); ++i) {
            jsw.writeln(this.source.get(i).toString());
        }
    }

    public void unindent() {
        if (this.currentIndent == 0) {
            throw new ModelloRuntimeException("Cannot unindent: current indent is 0.");
        }
        this.currentIndent = (short)(this.currentIndent - this.indentSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        for (int i = 0; i < this.source.size(); ++i) {
            sb.append(this.source.get(i).toString());
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private void addCodeStatement(JCodeStatement jcs) {
        short indent = (short)(jcs.getIndent() + this.currentIndent - JCodeStatement.DEFAULT_INDENTSIZE);
        this.source.add(new JCodeStatement(jcs.getStatement(), indent));
    }
}

