package org.codehaus.plexus.taskqueue.execution;

import org.codehaus.plexus.taskqueue.Task;

/*
 * The MIT License
 *
 * Copyright (c) 2004, The Codehaus
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @version $Id: TaskQueueExecutor.java 700 2009-01-12 18:34:56Z olamy $
 */
public interface TaskQueueExecutor
{
    String ROLE = TaskQueueExecutor.class.getName();

    /**
     * Returns the currently executing task.
     *
     * @return the currently executing task.
     */
    Task getCurrentTask();

    /**
     * Cancels execution of this task, if it's currently running.
     * Does NOT remove it from the associated queue!
     *
     * @param task The task to cancel
     * @return true if the task was cancelled, false if the task was not executing.
     */
    boolean cancelTask( Task task );
}
