/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.taskqueue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskEntryEvaluator;
import org.codehaus.plexus.taskqueue.TaskExitEvaluator;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.codehaus.plexus.taskqueue.TaskViabilityEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskQueue
implements TaskQueue {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<TaskEntryEvaluator> taskEntryEvaluators = new ArrayList<TaskEntryEvaluator>();
    private List<TaskExitEvaluator> taskExitEvaluators = new ArrayList<TaskExitEvaluator>();
    private List<TaskViabilityEvaluator> taskViabilityEvaluators = new ArrayList<TaskViabilityEvaluator>();
    private BlockingQueue<Task> queue = new LinkedBlockingQueue<Task>();

    @Override
    public boolean put(Task task) throws TaskQueueException {
        for (TaskEntryEvaluator taskEntryEvaluator : this.taskEntryEvaluators) {
            boolean result = taskEntryEvaluator.evaluate(task);
            if (result) continue;
            return false;
        }
        this.enqueue(task);
        for (TaskViabilityEvaluator taskViabilityEvaluator : this.taskViabilityEvaluators) {
            Collection<Task> toBeRemoved = taskViabilityEvaluator.evaluate(Collections.unmodifiableCollection(this.queue));
            for (Task t : toBeRemoved) {
                this.queue.remove(t);
            }
        }
        return true;
    }

    @Override
    public Task take() throws TaskQueueException {
        Task task;
        this.logger.debug("take");
        block0: do {
            if ((task = this.dequeue()) == null) {
                return null;
            }
            for (TaskExitEvaluator taskExitEvaluator : this.taskExitEvaluators) {
                boolean result = taskExitEvaluator.evaluate(task);
                if (result) continue;
                task = null;
                continue block0;
            }
        } while (task == null);
        return task;
    }

    @Override
    public Task poll(int timeout, TimeUnit timeUnit) throws InterruptedException {
        this.logger.debug("pool");
        return this.queue.poll(timeout, timeUnit);
    }

    @Override
    public boolean remove(Task task) throws ClassCastException, NullPointerException {
        return this.queue.remove(task);
    }

    @Override
    public boolean removeAll(List tasks) throws ClassCastException, NullPointerException {
        return this.queue.removeAll(tasks);
    }

    @Override
    public List<Task> getQueueSnapshot() throws TaskQueueException {
        return Collections.unmodifiableList(new ArrayList<Task>(this.queue));
    }

    private void enqueue(Task task) {
        boolean success = this.queue.add(task);
        this.logger.debug("enqueue success {}", (Object)success);
    }

    private Task dequeue() {
        this.logger.debug("dequeue");
        return (Task)this.queue.poll();
    }

    public List<TaskEntryEvaluator> getTaskEntryEvaluators() {
        return this.taskEntryEvaluators;
    }

    public void setTaskEntryEvaluators(List<TaskEntryEvaluator> taskEntryEvaluators) {
        this.taskEntryEvaluators = taskEntryEvaluators;
    }

    public List<TaskExitEvaluator> getTaskExitEvaluators() {
        return this.taskExitEvaluators;
    }

    public void setTaskExitEvaluators(List<TaskExitEvaluator> taskExitEvaluators) {
        this.taskExitEvaluators = taskExitEvaluators;
    }

    public List<TaskViabilityEvaluator> getTaskViabilityEvaluators() {
        return this.taskViabilityEvaluators;
    }

    public void setTaskViabilityEvaluators(List<TaskViabilityEvaluator> taskViabilityEvaluators) {
        this.taskViabilityEvaluators = taskViabilityEvaluators;
    }
}

