/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.sslr.ast.AstSelect;
import org.sonar.sslr.parser.LexerlessGrammar;

public class AbstractDeprecatedChecker
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.TYPE_DECLARATION, JavaGrammar.CLASS_BODY_DECLARATION, JavaGrammar.INTERFACE_BODY_DECLARATION, JavaGrammar.ANNOTATION_TYPE_ELEMENT_DECLARATION, JavaGrammar.BLOCK_STATEMENT});
    }

    public static boolean isDeprecated(AstNode node) {
        AstNode qualifiedIdentifier = node.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
        return qualifiedIdentifier.getNumberOfChildren() == 1 && "Deprecated".equals(qualifiedIdentifier.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenOriginalValue());
    }

    public static boolean hasJavadocDeprecatedTag(AstNode node) {
        Token token = node.getToken();
        for (Trivia trivia : token.getTrivia()) {
            String comment = trivia.getToken().getOriginalValue();
            if (!AbstractDeprecatedChecker.hasJavadocDeprecatedTag(comment)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasJavadocDeprecatedTag(String comment) {
        return comment.startsWith("/**") && comment.contains("@deprecated");
    }

    public static boolean hasDeprecatedAnnotationExcludingLocalVariables(AstNode node) {
        AstSelect annotations = node.select().children((AstNodeType)JavaGrammar.MODIFIER).children((AstNodeType)JavaGrammar.ANNOTATION);
        return AbstractDeprecatedChecker.hasDeprecatedAnnotation((Iterable<AstNode>)annotations);
    }

    public static boolean hasDeprecatedAnnotationOnLocalVariables(AstNode node) {
        AstSelect annotations = node.select().children((AstNodeType)JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT).children((AstNodeType)JavaGrammar.VARIABLE_MODIFIERS).children((AstNodeType)JavaGrammar.ANNOTATION);
        return AbstractDeprecatedChecker.hasDeprecatedAnnotation((Iterable<AstNode>)annotations);
    }

    public static boolean hasDeprecatedAnnotation(Iterable<AstNode> query) {
        for (AstNode annotation : query) {
            if (!AbstractDeprecatedChecker.isDeprecated(annotation)) continue;
            return true;
        }
        return false;
    }
}

