/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1182", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CloneMethodCallsSuperCloneCheck
extends SquidCheck<LexerlessGrammar> {
    private boolean foundSuperClone;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.MEMBER_DECL});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.PRIMARY});
    }

    public void visitNode(AstNode node) {
        if (CloneMethodCallsSuperCloneCheck.isCloneMethod(node)) {
            this.foundSuperClone = false;
        } else if (CloneMethodCallsSuperCloneCheck.isSuperCloneCall(node)) {
            this.foundSuperClone = true;
        }
    }

    public void leaveNode(AstNode node) {
        if (CloneMethodCallsSuperCloneCheck.isCloneMethod(node) && !this.foundSuperClone) {
            this.getContext().createLineViolation((CodeCheck)this, "Use super.clone() to create and seed the cloned instance to be returned.", node, new Object[0]);
        }
    }

    private static boolean isCloneMethod(AstNode node) {
        AstNode methodRest = node.getFirstChild(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST});
        return node.is(new AstNodeType[]{JavaGrammar.MEMBER_DECL}) && methodRest != null && "clone".equals(node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenOriginalValue()) && !methodRest.getFirstChild(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETERS}).hasDirectChildren(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETER_DECLS});
    }

    private static boolean isSuperCloneCall(AstNode node) {
        AstNode superSuffix = node.getFirstChild(new AstNodeType[]{JavaGrammar.SUPER_SUFFIX});
        return node.is(new AstNodeType[]{JavaGrammar.PRIMARY}) && superSuffix != null && CloneMethodCallsSuperCloneCheck.isCloneCallSuffix(superSuffix);
    }

    private static boolean isCloneCallSuffix(AstNode node) {
        AstNode identifier = node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        AstNode arguments = node.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS});
        return identifier != null && "clone".equals(identifier.getTokenOriginalValue()) && arguments != null && CloneMethodCallsSuperCloneCheck.isEmptyArguments(arguments);
    }

    private static boolean isEmptyArguments(AstNode node) {
        return !node.hasDirectChildren(new AstNodeType[]{JavaGrammar.EXPRESSION});
    }
}

