/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.checks.AstNodeTokensMatcher;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1215", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class GarbageCollectorCalledCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.PRIMARY});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.UNARY_EXPRESSION});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.UNARY_EXPRESSION_NOT_PLUS_MINUS});
    }

    public void visitNode(AstNode node) {
        if (GarbageCollectorCalledCheck.isGarbageCollectorCall(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Don't try to be smarter than the JVM, remove this call to run the garbage collector.", node, new Object[0]);
        }
    }

    private static boolean isGarbageCollectorCall(AstNode node) {
        return AstNodeTokensMatcher.matches(node, "System.gc()") || AstNodeTokensMatcher.matches(node, "Runtime.getRuntime().gc()");
    }
}

