/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1214", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class InterfaceAsConstantContainerCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.INTERFACE_BODY});
    }

    public void visitNode(AstNode node) {
        if (InterfaceAsConstantContainerCheck.hasConstant(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Move constants to a class or enum.", node, new Object[0]);
        }
    }

    private static boolean hasConstant(AstNode node) {
        for (AstNode declaration : node.getChildren(new AstNodeType[]{JavaGrammar.INTERFACE_BODY_DECLARATION})) {
            if (!InterfaceAsConstantContainerCheck.isConstant(declaration)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConstant(AstNode declaration) {
        AstNode memberDecl = declaration.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_MEMBER_DECL});
        if (memberDecl == null) {
            return false;
        }
        AstNode methodOrFieldDecl = declaration.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_MEMBER_DECL}).getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_OR_FIELD_DECL});
        return methodOrFieldDecl != null && methodOrFieldDecl.getFirstChild(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_OR_FIELD_REST}).hasDirectChildren(new AstNodeType[]{JavaGrammar.CONSTANT_DECLARATORS_REST});
    }
}

