/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.annotations.Beta;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1602", priority=Priority.MAJOR, tags={"java8"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
@Beta
public class LambdaSingleExpressionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1602";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S1602");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        if (this.isBlockWithOneStatement(lambdaExpressionTree)) {
            String message = "Remove useless curly braces around statement";
            if (this.singleStatementIsReturn(lambdaExpressionTree)) {
                message = message + " and then remove useless return keyword";
            }
            this.context.addIssue(lambdaExpressionTree.body(), RULE, message);
        }
        super.visitLambdaExpression(lambdaExpressionTree);
    }

    private boolean isBlockWithOneStatement(LambdaExpressionTree lambdaExpressionTree) {
        return lambdaExpressionTree.body().is(Tree.Kind.BLOCK) && ((BlockTree)lambdaExpressionTree.body()).body().size() == 1;
    }

    private boolean singleStatementIsReturn(LambdaExpressionTree lambdaExpressionTree) {
        return ((StatementTree)((BlockTree)lambdaExpressionTree.body()).body().get(0)).is(Tree.Kind.RETURN_STATEMENT);
    }
}

