/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1141", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class NestedTryCatchCheck
extends SquidCheck<LexerlessGrammar> {
    private int nestingLevel;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.BLOCK});
    }

    public void visitFile(AstNode node) {
        this.nestingLevel = 0;
    }

    public void visitNode(AstNode node) {
        if (NestedTryCatchCheck.isTryCatchBlock(node)) {
            ++this.nestingLevel;
            if (this.nestingLevel > 1) {
                this.getContext().createLineViolation((CodeCheck)this, "Extract this nested try block into a separate method.", node, new Object[0]);
            }
        }
    }

    public void leaveNode(AstNode node) {
        if (NestedTryCatchCheck.isTryCatchBlock(node)) {
            --this.nestingLevel;
        }
    }

    private static boolean isTryCatchBlock(AstNode node) {
        return node.getParent().is(new AstNodeType[]{JavaGrammar.TRY_STATEMENT}) && node.getParent().hasDirectChildren(new AstNodeType[]{JavaGrammar.CATCH_CLAUSE});
    }
}

