/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1175", priority=Priority.MAJOR, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ObjectFinalizeOverloadedCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        MethodHelper.subscribe((SquidAstVisitor)this);
    }

    public void visitNode(AstNode node) {
        MethodHelper method = new MethodHelper(node);
        if ("finalize".equals(method.getName().getTokenOriginalValue()) && !method.getParameters().isEmpty()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this method to avoid any possible confusion with Object.finalize().", node, new Object[0]);
        }
    }
}

