/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.List;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1168", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ReturnEmptyArrayyNotNullCheck
extends SquidCheck<LexerlessGrammar> {
    private static final Set<String> COLLECTION_TYPES = ImmutableSet.of((Object)"Collection", (Object)"BeanContext", (Object)"BeanContextServices", (Object)"BlockingDeque", (Object)"BlockingQueue", (Object)"Deque", (Object[])new String[]{"List", "NavigableSet", "Queue", "Set", "SortedSet", "AbstractCollection", "AbstractList", "AbstractQueue", "AbstractSequentialList", "AbstractSet", "ArrayBlockingQueue", "ArrayDeque", "ArrayList", "AttributeList", "BeanContextServicesSupport", "BeanContextSupport", "ConcurrentLinkedQueue", "ConcurrentSkipListSet", "CopyOnWriteArrayList", "CopyOnWriteArraySet", "DelayQueue", "EnumSet", "HashSet", "JobStateReasons", "LinkedBlockingDeque", "LinkedBlockingQueue", "LinkedHashSet", "LinkedList", "PriorityBlockingQueue", "PriorityQueue", "RoleList", "RoleUnresolvedList", "Stack", "SynchronousQueue", "TreeSet", "Vector"});

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.RETURN_STATEMENT});
    }

    public void visitNode(AstNode node) {
        if (ReturnEmptyArrayyNotNullCheck.isReturningNull(node)) {
            AstNode method = ReturnEmptyArrayyNotNullCheck.getMethod(node);
            if (ReturnEmptyArrayyNotNullCheck.isReturningArray(method)) {
                this.getContext().createLineViolation((CodeCheck)this, "Return an empty array instead of null.", node, new Object[0]);
            } else if (ReturnEmptyArrayyNotNullCheck.isReturningCollection(method)) {
                this.getContext().createLineViolation((CodeCheck)this, "Return an empty collection instead of null.", node, new Object[0]);
            }
        }
    }

    private static boolean isReturningNull(AstNode node) {
        AstNode expression = node.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION});
        return expression != null && expression.getToken().equals(expression.getLastToken()) && "null".equals(expression.getTokenOriginalValue());
    }

    private static AstNode getMethod(AstNode node) {
        return node.getFirstAncestor(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.CLASS_BODY_DECLARATION, JavaGrammar.INTERFACE_METHOD_OR_FIELD_REST, JavaGrammar.INTERFACE_GENERIC_METHOD_DECL});
    }

    private static boolean isReturningArray(AstNode node) {
        AstNode type = ReturnEmptyArrayyNotNullCheck.getType(node);
        return node.hasDirectChildren(new AstNodeType[]{JavaGrammar.DIM}) || type != null && type.hasDirectChildren(new AstNodeType[]{JavaGrammar.DIM});
    }

    private static boolean isReturningCollection(AstNode node) {
        AstNode type = ReturnEmptyArrayyNotNullCheck.getType(node);
        if (type == null) {
            return false;
        }
        AstNode classType = type.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_TYPE});
        if (classType == null) {
            return false;
        }
        List identifiers = classType.getChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        String lastIdentifierValue = ((AstNode)identifiers.get(identifiers.size() - 1)).getTokenOriginalValue();
        return COLLECTION_TYPES.contains(lastIdentifierValue);
    }

    private static AstNode getType(AstNode node) {
        AstNode type = node.getParent().getFirstChild(new AstNodeType[]{JavaGrammar.TYPE});
        if (node.is(new AstNodeType[]{JavaGrammar.INTERFACE_GENERIC_METHOD_DECL})) {
            type = node.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE});
        }
        return type;
    }
}

