/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1126", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ReturnOfBooleanExpressionsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.IF_STATEMENT});
    }

    public void visitNode(AstNode node) {
        if (ReturnOfBooleanExpressionsCheck.hasElse(node) && ReturnOfBooleanExpressionsCheck.isReturnBooleanLiteral(ReturnOfBooleanExpressionsCheck.getTrueStatement(node)) && ReturnOfBooleanExpressionsCheck.isReturnBooleanLiteral(ReturnOfBooleanExpressionsCheck.getFalseStatement(node))) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this if-then-else statement by a single return statement.", node, new Object[0]);
        }
    }

    private static boolean hasElse(AstNode node) {
        return node.hasDirectChildren(new AstNodeType[]{JavaKeyword.ELSE});
    }

    private static AstNode getTrueStatement(AstNode node) {
        return node.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT});
    }

    private static AstNode getFalseStatement(AstNode node) {
        return node.getLastChild();
    }

    private static boolean isReturnBooleanLiteral(AstNode node) {
        return ReturnOfBooleanExpressionsCheck.isBlockReturnBooleanLiteral(node) || ReturnOfBooleanExpressionsCheck.isSimpleReturnBooleanLiteral(node);
    }

    private static boolean isBlockReturnBooleanLiteral(AstNode node) {
        AstNode block = node.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK});
        if (block == null) {
            return false;
        }
        List blockStatements = block.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS}).getChildren(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT});
        return blockStatements.size() == 1 && ((AstNode)blockStatements.get(0)).hasDirectChildren(new AstNodeType[]{JavaGrammar.STATEMENT}) && ReturnOfBooleanExpressionsCheck.isSimpleReturnBooleanLiteral(((AstNode)blockStatements.get(0)).getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT}));
    }

    private static boolean isSimpleReturnBooleanLiteral(AstNode node) {
        AstNode returnStatement = node.getFirstChild(new AstNodeType[]{JavaGrammar.RETURN_STATEMENT});
        return returnStatement != null && returnStatement.hasDirectChildren(new AstNodeType[]{JavaGrammar.EXPRESSION}) && ReturnOfBooleanExpressionsCheck.isBooleanLiteral(returnStatement.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION}));
    }

    private static boolean isBooleanLiteral(AstNode node) {
        return ReturnOfBooleanExpressionsCheck.hasSingleToken(node) && node.hasDescendant(new AstNodeType[]{JavaKeyword.FALSE, JavaKeyword.TRUE});
    }

    private static boolean hasSingleToken(AstNode node) {
        return node.getToken().equals(node.getLastToken());
    }
}

