/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="RightCurlyBraceDifferentLineAsNextBlockCheck", priority=Priority.MAJOR, tags={"convention"})
public class RightCurlyBraceDifferentLineAsNextBlockCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final Set<String> NEXT_BLOCKS = ImmutableSet.of((Object)"else", (Object)"catch", (Object)"finally");
    private boolean lastTokenIsRightCurlyBrace;
    private int lastTokenLine;

    public void visitFile(AstNode astNode) {
        this.lastTokenIsRightCurlyBrace = false;
        this.lastTokenLine = -1;
    }

    public void visitToken(Token token) {
        if (this.lastTokenIsRightCurlyBrace && this.lastTokenLine == token.getLine() && NEXT_BLOCKS.contains(token.getValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this \"" + token.getValue() + "\" keyword to a new dedicated line.", token, new Object[0]);
        }
        this.lastTokenIsRightCurlyBrace = "}".equals(token.getValue());
        this.lastTokenLine = token.getLine();
    }
}

