/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.util.Map;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1192", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class StringLiteralDuplicatedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1192";
    private static final int DEFAULT_THRESHOLD = 3;
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1192");
    private static final Integer MINIMAL_LITERAL_LENGTH = 7;
    @RuleProperty(key="threshold", defaultValue="3")
    public int threshold = 3;
    private final Map<String, LiteralTree> firstOccurrence = Maps.newHashMap();
    private final Multiset<String> occurences = HashMultiset.create();

    public void scanFile(JavaFileScannerContext context) {
        this.firstOccurrence.clear();
        this.occurences.clear();
        this.scan((Tree)context.getTree());
        for (String literal : this.occurences.elementSet()) {
            int literalOccurence = this.occurences.count((Object)literal);
            if (literalOccurence < this.threshold) continue;
            context.addIssue((Tree)this.firstOccurrence.get(literal), this.ruleKey, "Define a constant instead of duplicating this literal " + literal + " " + literalOccurence + " times.");
        }
    }

    public void visitLiteral(LiteralTree tree) {
        String literal;
        if (tree.is(Tree.Kind.STRING_LITERAL) && (literal = tree.value()).length() >= MINIMAL_LITERAL_LENGTH) {
            if (!this.firstOccurrence.containsKey(literal)) {
                this.firstOccurrence.put(literal, tree);
            }
            this.occurences.add((Object)literal);
        }
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
    }
}

