/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1191", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SunPackagesUsedCheck
extends SquidCheck<LexerlessGrammar> {
    private int lastReportedLine;
    private static final String DEFAULT_EXCLUDE = "";
    @RuleProperty(key="exclude", defaultValue="")
    public String exclude = "";
    private String[] excludePackages = null;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_TYPE});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CREATED_NAME});
    }

    public void visitFile(AstNode node) {
        this.lastReportedLine = -1;
        this.excludePackages = this.exclude.split(",");
    }

    public void visitNode(AstNode node) {
        String reference = this.merge(node);
        if (this.lastReportedLine != node.getTokenLine() && this.isSunClass(reference) && !this.isExcluded(reference)) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this usage of Sun classes by ones from the Java API.", node, new Object[0]);
            this.lastReportedLine = node.getTokenLine();
        }
    }

    private boolean isSunClass(String reference) {
        return reference.startsWith("com.sun.") || reference.startsWith("sun.");
    }

    private String merge(AstNode node) {
        StringBuilder sb = new StringBuilder();
        for (Token token : node.getTokens()) {
            sb.append(token.getOriginalValue());
        }
        return sb.toString();
    }

    private boolean isExcluded(String reference) {
        for (String str : this.excludePackages) {
            if (str.isEmpty() || !reference.startsWith(str)) continue;
            return true;
        }
        return false;
    }
}

