/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Map;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.checks.AstNodeTokensMatcher;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1149", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SynchronizedClassUsageCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    public static final String RULE_KEY = "S1149";
    private static final RuleKey RULE_KEY_FOR_REPOSITORY = RuleKey.of((String)"squid", (String)"S1149");
    private static final Map<String, String> REPLACEMENTS = ImmutableMap.builder().put((Object)"Vector", (Object)"\"ArrayList\" or \"LinkedList\"").put((Object)"Hashtable", (Object)"\"HashMap\"").put((Object)"StringBuffer", (Object)"\"StringBuilder\"").put((Object)"Stack", (Object)"\"Deque\"").build();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        String declaredType = this.getTypeName(tree.type());
        if (REPLACEMENTS.containsKey(declaredType)) {
            this.reportIssue(tree.type(), declaredType);
        } else {
            ExpressionTree init = tree.initializer();
            if (init != null && init.is(Tree.Kind.NEW_CLASS)) {
                String initType = this.getTypeName(((NewClassTree)tree.initializer()).identifier());
                this.reportIssueIfDeprecatedType((Tree)tree.initializer(), initType);
            }
        }
    }

    public void visitMethod(MethodTree tree) {
        this.scan((Tree)tree.modifiers());
        this.scan(tree.typeParameters());
        this.scan(tree.returnType());
        this.scan((Tree)tree.defaultValue());
        this.scan((Tree)tree.block());
        if (!this.isOverriding(tree)) {
            for (VariableTree param : tree.parameters()) {
                this.reportIssueIfDeprecatedType((Tree)param, this.getTypeName(param.type()));
            }
            this.reportIssueIfDeprecatedType((Tree)tree, this.getTypeName(tree.returnType()));
        }
    }

    public void visitClass(ClassTree tree) {
        super.visitClass(tree);
        for (Tree parent : tree.superInterfaces()) {
            this.reportIssueIfDeprecatedType(parent, this.getTypeName(parent));
        }
    }

    private void reportIssueIfDeprecatedType(Tree tree, String type) {
        if (REPLACEMENTS.containsKey(type)) {
            this.reportIssue(tree, type);
        }
    }

    private void reportIssue(Tree tree, String type) {
        this.context.addIssue(tree, RULE_KEY_FOR_REPOSITORY, "Replace the synchronized class \"" + type + "\" by an unsynchronized one such as " + REPLACEMENTS.get(type) + ".");
    }

    private String getTypeName(Tree typeTree) {
        if (typeTree != null) {
            if (typeTree.is(Tree.Kind.IDENTIFIER)) {
                return ((IdentifierTree)typeTree).name();
            }
            if (typeTree.is(Tree.Kind.MEMBER_SELECT)) {
                return ((MemberSelectExpressionTree)typeTree).identifier().name();
            }
            if (typeTree.is(Tree.Kind.PARAMETERIZED_TYPE)) {
                return this.getTypeName(((ParameterizedTypeTree)typeTree).type());
            }
        }
        return "";
    }

    private boolean isOverriding(MethodTree tree) {
        AstNode memberDec = ((JavaTree)tree).getAstNode().getParent().getParent();
        for (AstNode modifier : memberDec.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER})) {
            if (!AstNodeTokensMatcher.matches(modifier, "@Override")) continue;
            return true;
        }
        return false;
    }
}

