/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.checks.AstNodeTokensMatcher;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1147", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class SystemExitCalledCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.PRIMARY});
    }

    public void visitNode(AstNode node) {
        if (SystemExitCalledCheck.isMethodCall(node) && SystemExitCalledCheck.isCallToExitMethod(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this exit() call or ensure it is really required.", node, new Object[0]);
        }
    }

    private static boolean isMethodCall(AstNode node) {
        AstNode suffix = node.getFirstChild(new AstNodeType[]{JavaGrammar.IDENTIFIER_SUFFIX});
        return suffix != null && suffix.hasDirectChildren(new AstNodeType[]{JavaGrammar.ARGUMENTS});
    }

    private static boolean isCallToExitMethod(AstNode node) {
        AstNode qualifiedIdentifier = node.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
        return AstNodeTokensMatcher.matches(qualifiedIdentifier, "System.exit") || AstNodeTokensMatcher.matches(qualifiedIdentifier, "Runtime.getRuntime") && SystemExitCalledCheck.hasExitCallSuffix(node.getParent());
    }

    private static boolean hasExitCallSuffix(AstNode node) {
        AstNode selector = node.getFirstChild(new AstNodeType[]{JavaGrammar.SELECTOR});
        return selector != null && selector.hasDirectChildren(new AstNodeType[]{JavaGrammar.ARGUMENTS}) && "exit".equals(selector.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenValue());
    }
}

