/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00104", priority=Priority.MAJOR, tags={"brain-overload"})
public class TooManyLinesOfCodeInFile_S00104_Check
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final int DEFAULT_MAXIMUM = 1000;
    @RuleProperty(key="maximumFileLocThreshold", defaultValue="1000")
    public int maximum = 1000;

    public void visitToken(Token token) {
        int lines;
        if (token.getType() == GenericTokenType.EOF && (lines = token.getLine()) > this.maximum) {
            this.getContext().createFileViolation((CodeCheck)this, "This file has {0} lines, which is greater than {1} authorized. Split it into smaller files.", new Object[]{lines, this.maximum});
        }
    }
}

