/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="UselessImportCheck", priority=Priority.MINOR, tags={"unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class UselessImportCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private final Map<String, Integer> lineByImportReference = Maps.newHashMap();
    private final Set<String> pendingImports = Sets.newHashSet();
    private final Set<String> pendingReferences = Sets.newHashSet();
    private String currentPackage;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.PACKAGE_DECLARATION});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.IMPORT_DECLARATION});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_TYPE});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CREATED_NAME});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.ANNOTATION});
        this.subscribeTo(new AstNodeType[]{JavaKeyword.THROWS});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
    }

    public void visitFile(AstNode astNode) {
        this.pendingReferences.clear();
        this.lineByImportReference.clear();
        this.pendingImports.clear();
        this.currentPackage = "";
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.PACKAGE_DECLARATION})) {
            this.currentPackage = UselessImportCheck.mergeIdentifiers(node.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}));
        } else if (node.is(new AstNodeType[]{JavaGrammar.IMPORT_DECLARATION})) {
            if (!UselessImportCheck.isStaticImport(node)) {
                String reference = UselessImportCheck.mergeIdentifiers(node.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}));
                if ("java.lang".equals(reference)) {
                    this.getContext().createLineViolation((CodeCheck)this, "Remove this unnecessary import: java.lang classes are always implicitly imported.", node, new Object[0]);
                } else if (this.isImportFromSamePackage(reference)) {
                    this.getContext().createLineViolation((CodeCheck)this, "Remove this unnecessary import: same package classes are always implicitly imported.", node, new Object[0]);
                } else if (!UselessImportCheck.isImportOnDemand(node)) {
                    if (UselessImportCheck.isJavaLangImport(reference)) {
                        this.getContext().createLineViolation((CodeCheck)this, "Remove this unnecessary import: java.lang classes are always implicitly imported.", node, new Object[0]);
                    } else if (this.isDuplicatedImport(reference)) {
                        this.getContext().createLineViolation((CodeCheck)this, "Remove this duplicated import.", node, new Object[0]);
                    } else {
                        this.lineByImportReference.put(reference, node.getTokenLine());
                        this.pendingImports.add(reference);
                    }
                }
            }
        } else if (!node.getParent().is(new AstNodeType[]{JavaGrammar.IMPORT_DECLARATION})) {
            this.pendingReferences.addAll(UselessImportCheck.getReferences(node));
        }
    }

    public void leaveFile(AstNode node) {
        for (String reference : this.pendingReferences) {
            this.updatePendingImports(reference);
        }
        for (String pendingImport : this.pendingImports) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this unused import '" + pendingImport + "'.", this.lineByImportReference.get(pendingImport).intValue(), new Object[0]);
        }
    }

    private static boolean isJavaLangImport(String reference) {
        return reference.startsWith("java.lang.") && reference.indexOf(46, "java.lang.".length()) == -1;
    }

    private boolean isImportFromSamePackage(String reference) {
        return !this.currentPackage.isEmpty() && reference.startsWith(this.currentPackage) && (reference.length() == this.currentPackage.length() || reference.substring(reference.indexOf(this.currentPackage)).startsWith("."));
    }

    private boolean isDuplicatedImport(String reference) {
        return this.pendingImports.contains(reference);
    }

    private void updatePendingImports(String reference) {
        String firstClassReference = reference;
        if (UselessImportCheck.isFullyQualified(firstClassReference)) {
            firstClassReference = UselessImportCheck.extractFirstClassName(firstClassReference);
        }
        Iterator<String> it = this.pendingImports.iterator();
        while (it.hasNext()) {
            String pendingImport = it.next();
            if (!pendingImport.endsWith(firstClassReference)) continue;
            it.remove();
        }
    }

    private static boolean isFullyQualified(String reference) {
        return reference.indexOf(46) != -1;
    }

    private static Collection<String> getReferences(AstNode node) {
        if (node.is(new AstNodeType[]{JavaKeyword.THROWS})) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (AstNode qualifiedIdentifier : node.getNextSibling().getChildren(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER})) {
                builder.add((Object)UselessImportCheck.mergeIdentifiers(qualifiedIdentifier));
            }
            return builder.build();
        }
        AstNode actualNode = node;
        if (node.is(new AstNodeType[]{JavaGrammar.ANNOTATION})) {
            actualNode = node.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
        }
        return Collections.singleton(UselessImportCheck.mergeIdentifiers(actualNode));
    }

    private static String mergeIdentifiers(AstNode node) {
        StringBuilder sb = new StringBuilder();
        for (AstNode child : node.getChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER})) {
            sb.append(child.getTokenOriginalValue());
            sb.append('.');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static boolean isStaticImport(AstNode node) {
        return node.hasDirectChildren(new AstNodeType[]{JavaKeyword.STATIC});
    }

    private static boolean isImportOnDemand(AstNode node) {
        return node.hasDirectChildren(new AstNodeType[]{JavaPunctuator.STAR});
    }

    public void visitToken(Token token) {
        if (token.hasTrivia()) {
            for (Trivia trivia : token.getTrivia()) {
                this.updatePendingImportsForComments(trivia.getToken().getOriginalValue());
            }
        }
    }

    private void updatePendingImportsForComments(String comment) {
        Iterator<String> it = this.pendingImports.iterator();
        while (it.hasNext()) {
            String pendingImport = it.next();
            if (!comment.contains(UselessImportCheck.extractLastClassName(pendingImport))) continue;
            it.remove();
        }
    }

    private static String extractFirstClassName(String reference) {
        int firstIndexOfDot = reference.indexOf(46);
        return firstIndexOfDot == -1 ? reference : reference.substring(0, firstIndexOfDot);
    }

    private static String extractLastClassName(String reference) {
        int lastIndexOfDot = reference.lastIndexOf(46);
        return lastIndexOfDot == -1 ? reference : reference.substring(lastIndexOfDot + 1);
    }
}

