/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jacoco.agent.AgentJar;
import org.jacoco.core.JaCoCo;
import org.sonar.api.BatchExtension;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jacoco.JaCoCoExtensions;

public class JaCoCoAgentDownloader
implements BatchExtension {
    private static File agentJarFile;

    public synchronized File getAgentJarFile() {
        if (agentJarFile == null) {
            agentJarFile = this.extractAgent();
        }
        return agentJarFile;
    }

    private File extractAgent() {
        try {
            File agent = File.createTempFile("jacocoagent", ".jar");
            AgentJar.extractTo((File)agent);
            FileUtils.forceDeleteOnExit((File)agent);
            JaCoCoExtensions.LOG.info("JaCoCo agent (version " + JaCoCo.VERSION + ") extracted: {}", (Object)agent);
            return agent;
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
    }
}

