/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.util.Collection;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.jacoco.AbstractAnalyzer;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.jacoco.JacocoConfiguration;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class JaCoCoSensor
implements Sensor {
    private final JacocoConfiguration configuration;
    private final ResourcePerspectives perspectives;
    private final ModuleFileSystem fileSystem;
    private final PathResolver pathResolver;
    private final JavaResourceLocator javaResourceLocator;
    private final JavaClasspath javaClasspath;

    public JaCoCoSensor(JacocoConfiguration configuration, ResourcePerspectives perspectives, ModuleFileSystem fileSystem, PathResolver pathResolver, JavaResourceLocator javaResourceLocator, JavaClasspath javaClasspath) {
        this.configuration = configuration;
        this.perspectives = perspectives;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.javaResourceLocator = javaResourceLocator;
        this.javaClasspath = javaClasspath;
    }

    @DependsUpon
    public String dependsOnSurefireSensors() {
        return "surefire-java";
    }

    public void analyse(Project project, SensorContext context) {
        new UnitTestsAnalyzer(this.perspectives).analyse(project, context);
    }

    public boolean shouldExecuteOnProject(Project project) {
        File report = this.pathResolver.relativeFile(this.fileSystem.baseDir(), this.configuration.getReportPath());
        boolean foundReport = report.exists() && report.isFile();
        boolean shouldExecute = this.configuration.shouldExecuteOnProject(foundReport);
        if (!foundReport && shouldExecute) {
            JaCoCoExtensions.LOG.info("JaCoCoSensor: JaCoCo report not found.");
        }
        return shouldExecute;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    class UnitTestsAnalyzer
    extends AbstractAnalyzer {
        public UnitTestsAnalyzer(ResourcePerspectives perspectives) {
            super(perspectives, JaCoCoSensor.this.fileSystem, JaCoCoSensor.this.pathResolver, JaCoCoSensor.this.javaResourceLocator, JaCoCoSensor.this.javaClasspath);
        }

        @Override
        protected String getReportPath(Project project) {
            return JaCoCoSensor.this.configuration.getReportPath();
        }

        @Override
        protected void saveMeasures(SensorContext context, Resource resource, Collection<Measure> measures) {
            for (Measure measure : measures) {
                context.saveMeasure(resource, measure);
            }
        }
    }
}

