/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.InputFileUtils;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.VisitorContext;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.measures.MetricDef;

public class PackageVisitor
extends JavaAstVisitor {
    public void visitFile(AstNode astNode) {
        SourceProject sourceProject = (SourceProject)this.getContext().peekSourceCode();
        SourcePackage sourcePackage = PackageVisitor.findOrCreateSourcePackage(sourceProject, this.getPackageKey(astNode));
        sourcePackage.setMeasure((MetricDef)JavaMetric.PACKAGES, 1);
        this.getContext().addSourceCode((SourceCode)sourcePackage);
    }

    public void leaveFile(AstNode astNode) {
        Preconditions.checkState((boolean)this.getContext().peekSourceCode().isType(SourcePackage.class));
        this.getContext().popSourceCode();
    }

    private static SourcePackage findOrCreateSourcePackage(SourceProject sourceProject, String packageKey) {
        if (sourceProject.hasChildren()) {
            for (SourceCode child : sourceProject.getChildren()) {
                if (!child.getKey().equals(packageKey)) continue;
                return (SourcePackage)child;
            }
        }
        return new SourcePackage(packageKey);
    }

    private String getPackageKey(AstNode astNode) {
        String packageKey;
        if (astNode != null && astNode.getChild(0).is(new AstNodeType[]{JavaGrammar.PACKAGE_DECLARATION})) {
            AstNode packageNameNode = astNode.getChild(0).getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
            packageKey = PackageVisitor.getAstNodeValue(packageNameNode).replace('.', '/');
        } else {
            packageKey = InputFileUtils.getRelativeDirectory((InputFile)this.getInputFile());
        }
        this.checkPhysicalDirectory(packageKey);
        return packageKey;
    }

    private static String getAstNodeValue(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (AstNode child : astNode.getChildren()) {
            sb.append(child.getTokenValue());
        }
        return sb.toString();
    }

    private InputFile getInputFile() {
        return ((VisitorContext)this.getContext()).getInputFile();
    }

    private void checkPhysicalDirectory(String key) {
        String relativeDirectory = InputFileUtils.getRelativeDirectory((InputFile)this.getInputFile());
        if (!StringUtils.equals((String)relativeDirectory, (String)key)) {
            String packageName = StringUtils.replace((String)key, (String)"/", (String)".");
            if (StringUtils.contains((String)relativeDirectory, (String)key) || StringUtils.contains((String)key, (String)relativeDirectory)) {
                throw new AnalysisException(String.format("The source directory does not correspond to the package declaration %s", packageName));
            }
            throw new AnalysisException(String.format("The package declaration %s does not correspond to the file path %s", packageName, this.getInputFile().getRelativePath()));
        }
    }
}

