/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.CommentAnalyser;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.SquidAstVisitorContext;
import java.io.File;
import java.util.Stack;
import org.sonar.api.resources.InputFile;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceProject;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorContext
extends SquidAstVisitorContext<LexerlessGrammar> {
    private final Stack<SourceCode> sourceCodeStack = new Stack();
    private final SourceProject project;
    private File file;
    private CommentAnalyser commentAnalyser;
    private InputFile inputFile;

    public VisitorContext(SourceProject project) {
        if (project == null) {
            throw new IllegalArgumentException("project cannot be null.");
        }
        this.project = project;
        this.sourceCodeStack.add((SourceCode)project);
    }

    public void setCommentAnalyser(CommentAnalyser commentAnalyser) {
        this.commentAnalyser = commentAnalyser;
    }

    public CommentAnalyser getCommentAnalyser() {
        return this.commentAnalyser;
    }

    public void addSourceCode(SourceCode child) {
        this.peekSourceCode().addChild(child);
        this.sourceCodeStack.add(child);
    }

    public void popSourceCode() {
        this.sourceCodeStack.pop();
    }

    public SourceCode peekSourceCode() {
        return this.sourceCodeStack.peek();
    }

    public void setFile(File file) {
        this.popTillSourceProject();
        this.file = file;
    }

    private void popTillSourceProject() {
        while (!(this.peekSourceCode() instanceof SourceProject)) {
            this.popSourceCode();
        }
    }

    public File getFile() {
        return this.file;
    }

    public SourceProject getProject() {
        return this.project;
    }

    @Deprecated
    public LexerlessGrammar getGrammar() {
        return null;
    }

    public void createFileViolation(CodeCheck check, String message, Object ... messageParameters) {
        this.createLineViolation(check, message, -1, messageParameters);
    }

    public void createLineViolation(CodeCheck check, String message, AstNode node, Object ... messageParameters) {
        this.createLineViolation(check, message, node.getToken(), messageParameters);
    }

    public void createLineViolation(CodeCheck check, String message, Token token, Object ... messageParameters) {
        this.createLineViolation(check, message, token.getLine(), messageParameters);
    }

    public void createLineViolation(CodeCheck check, String message, int line, Object ... messageParameters) {
        CheckMessage checkMessage = new CheckMessage(check, message, messageParameters);
        if (line > 0) {
            checkMessage.setLine(line);
        }
        this.log(checkMessage);
    }

    private void log(CheckMessage message) {
        if (this.peekSourceCode() instanceof SourceFile) {
            this.peekSourceCode().log(message);
        } else if (this.peekSourceCode().getParent(SourceFile.class) != null) {
            ((SourceFile)this.peekSourceCode().getParent(SourceFile.class)).log(message);
        } else {
            throw new IllegalStateException("Unable to log a check message on source code '" + (this.peekSourceCode() == null ? "[NULL]" : this.peekSourceCode().getKey()) + "'");
        }
    }

    public void setInputFile(InputFile inputFile) {
        this.inputFile = inputFile;
    }

    public InputFile getInputFile() {
        return this.inputFile;
    }
}

