/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.sonar.java.bytecode.loader.Loader;

class FileSystemLoader
implements Loader {
    private File baseDir;

    public FileSystemLoader(File baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException("baseDir can't be null");
        }
        this.baseDir = baseDir;
    }

    public URL findResource(String name) {
        if (this.baseDir == null) {
            throw new IllegalStateException("Loader closed");
        }
        File file = new File(this.baseDir, name);
        if (file.exists() && file.isFile()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadBytes(String name) {
        byte[] byArray;
        if (this.baseDir == null) {
            throw new IllegalStateException("Loader closed");
        }
        File file = new File(this.baseDir, name);
        if (!file.exists()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byArray = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return byArray2;
        }
        IOUtils.closeQuietly((InputStream)is);
        return byArray;
    }

    public void close() {
        this.baseDir = null;
    }
}

