/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmResource;
import org.sonar.java.bytecode.asm.SourceCodeEdgeUsage;

public class AsmMethod
extends AsmResource {
    private final String name;
    private final String key;
    private boolean inherited = false;
    private boolean empty = false;
    private boolean bodyLoaded = true;
    private boolean accessedFieldComputed = false;
    private boolean accessedFieldBeingComputed = false;
    private boolean accessedFieldIsThisMethodRecursive = false;
    private AsmField accessedField = null;
    private String signature;
    private AsmMethod implementationLinkage = null;

    public AsmMethod(AsmClass parent, String name, String descriptor) {
        this.parent = parent;
        this.name = name;
        this.key = name + descriptor;
    }

    public AsmMethod(AsmClass parent, String key) {
        this.parent = parent;
        this.key = key;
        this.name = key.substring(0, key.indexOf(40));
    }

    void addThrowsOfClasses(AsmClass[] asmClasses) {
        for (AsmClass asmClass : asmClasses) {
            this.addEdge(new AsmEdge(this, asmClass, SourceCodeEdgeUsage.THROWS));
        }
    }

    public List<AsmClass> getThrows() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AsmEdge edge : this.getOutgoingEdges()) {
            if (edge.getUsage() != SourceCodeEdgeUsage.THROWS) continue;
            builder.add((Object)((AsmClass)edge.getTo()));
        }
        return builder.build();
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getGenericKey() {
        if (this.signature != null) {
            return this.name + this.signature;
        }
        return this.getKey();
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public List<AsmField> getCallsToField() {
        ArrayList<AsmField> callsToField = new ArrayList<AsmField>();
        for (AsmEdge usage : this.getOutgoingEdges()) {
            if (usage.getUsage() != SourceCodeEdgeUsage.CALLS_FIELD) continue;
            callsToField.add((AsmField)usage.getTo());
        }
        return callsToField;
    }

    public List<AsmMethod> getCallsToMethod() {
        ArrayList<AsmMethod> callsToMethod = new ArrayList<AsmMethod>();
        for (AsmEdge usage : this.getOutgoingEdges()) {
            if (usage.getUsage() != SourceCodeEdgeUsage.CALLS_METHOD) continue;
            callsToMethod.add((AsmMethod)usage.getTo());
        }
        return callsToMethod;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AsmMethod) {
            AsmMethod otherMethod = (AsmMethod)object;
            return this.parent.equals(otherMethod.parent) && this.key.equals(otherMethod.key);
        }
        return false;
    }

    public int hashCode() {
        return this.parent.hashCode() + this.key.hashCode();
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name) || "<clinit>".equals(this.name);
    }

    public boolean isDefaultConstructor() {
        return "<init>()V".equals(this.key);
    }

    void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isBodyLoaded() {
        return this.bodyLoaded;
    }

    void setBodyLoaded(boolean bodyLoaded) {
        this.bodyLoaded = bodyLoaded;
    }

    void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public boolean isAccessor() {
        return this.getAccessedField() != null;
    }

    public AsmField getAccessedField() {
        if (this.accessedFieldComputed) {
            return this.accessedField;
        }
        if (this.accessedFieldBeingComputed) {
            this.accessedFieldIsThisMethodRecursive = true;
            return null;
        }
        this.accessedFieldBeingComputed = true;
        this.computeAccessedField();
        if (this.accessedFieldIsThisMethodRecursive) {
            this.accessedField = null;
        }
        this.accessedFieldComputed = true;
        this.accessedFieldBeingComputed = false;
        return this.accessedField;
    }

    private void computeAccessedField() {
        if (!this.isConstructor()) {
            for (AsmEdge edge : this.getOutgoingEdges()) {
                if (this.isCallToNonStaticInternalField(edge)) {
                    if (this.isFieldAccesingDifferentField((AsmField)edge.getTo())) {
                        this.accessedField = null;
                        break;
                    }
                    this.accessedField = (AsmField)edge.getTo();
                    continue;
                }
                if (!this.isCallToNonStaticInternalMethod(edge)) continue;
                AsmMethod method = (AsmMethod)edge.getTo();
                if (this.isMethodNotAccessorOrAccessingDifferentField(method)) {
                    this.accessedField = null;
                    break;
                }
                this.accessedField = method.getAccessedField();
            }
        }
    }

    private boolean isMethodNotAccessorOrAccessingDifferentField(AsmMethod method) {
        return !method.isAccessor() || this.accessedField != null && !this.accessedField.equals(method.getAccessedField());
    }

    private boolean isFieldAccesingDifferentField(AsmField field) {
        return this.accessedField != null && this.accessedField != field;
    }

    private boolean isCallToNonStaticInternalField(AsmEdge edge) {
        return edge.getTargetAsmClass() == this.getParent() && edge.getUsage() == SourceCodeEdgeUsage.CALLS_FIELD && !((AsmField)edge.getTo()).isStatic();
    }

    private boolean isCallToNonStaticInternalMethod(AsmEdge edge) {
        return edge.getTargetAsmClass() == this.getParent() && edge.getUsage() == SourceCodeEdgeUsage.CALLS_METHOD && !((AsmMethod)edge.getTo()).isStatic();
    }

    public String toString() {
        return this.key;
    }

    public boolean isStaticConstructor() {
        return "<init>".equals(this.name);
    }

    public void linkTo(AsmMethod implementationLinkage) {
        this.implementationLinkage = implementationLinkage;
    }

    public AsmMethod getImplementationLinkage() {
        return this.implementationLinkage;
    }
}

